/*
 * Decompiled with CFR 0.152.
 */
public class Evaluater
extends Lisp51ToolKit {
    public LispObject Apply(LispObject lispObject, LispObject lispObject2) throws LispException {
        if (Evaluater.DebugMode()) {
            Evaluater.DebugPrint("Applying " + lispObject + " to " + lispObject2 + " in" + " environment " + environment);
        }
        Evaluater.Preserve(lispObject);
        Evaluater.Preserve(lispObject2);
        Evaluater.Preserve(environment);
        if (Evaluater.Builtinp(lispObject)) {
            if (Evaluater.CvtToBuiltin(lispObject).GetSpecial()) {
                throw new LispException("Apply: can't apply a special primitive " + Evaluater.CvtToBuiltin(lispObject).GetName());
            }
            environment = NIL;
            LispObject lispObject3 = Evaluater.CvtToBuiltin(lispObject).Call(lispObject2);
            environment = Evaluater.Release();
            if (Evaluater.DebugMode()) {
                Evaluater.DebugPrint("Apply done, set environment back to " + environment);
            }
            Evaluater.Release();
            Evaluater.Release();
            return lispObject3;
        }
        if (!(Evaluater.Consp(lispObject) && Evaluater.Consp(Evaluater.Cdr(lispObject)) && Evaluater.Listp(Evaluater.Cadr(lispObject)) && Evaluater.Consp(Evaluater.Cddr(lispObject)))) {
            throw new LispException("APPLY: not a function or LAMBDA expression " + lispObject);
        }
        if (Evaluater.Car(lispObject) == LAMBDA) {
            lispObject = Evaluater.MakeCons(LAMBDA_CLOSURE, Evaluater.MakeCons(NIL, Evaluater.Cdr(lispObject)));
        }
        if (!(Evaluater.Consp(lispObject) && Evaluater.Car(lispObject) == LAMBDA_CLOSURE && Evaluater.Consp(Evaluater.Cdr(lispObject)) && Evaluater.Listp(Evaluater.Cadr(lispObject)) && Evaluater.Consp(Evaluater.Cddr(lispObject)) && Evaluater.Listp(Evaluater.Caddr(lispObject)))) {
            throw new LispException("APPLY: not a function " + lispObject);
        }
        Evaluater.Preserve(lispObject);
        environment = Evaluater.Cadr(lispObject);
        this.BindArgs(Evaluater.Caddr(lispObject), lispObject2);
        LispObject lispObject4 = this.Progn(Evaluater.Cdddr(lispObject));
        Evaluater.Release();
        environment = Evaluater.Release();
        if (Evaluater.DebugMode()) {
            Evaluater.DebugPrint("Apply done, set environment back to " + environment);
        }
        Evaluater.Release();
        Evaluater.Release();
        return lispObject4;
    }

    public void BindArgs(LispObject lispObject, LispObject lispObject2) throws LispException {
        LispObject lispObject3 = lispObject2;
        LispObject lispObject4 = lispObject;
        while (Evaluater.Consp(lispObject4)) {
            if (Evaluater.Car(lispObject4) == REST) {
                if (!Evaluater.Consp(Evaluater.Cdr(lispObject4)) || !Evaluater.Symbolp(Evaluater.Cadr(lispObject4)) || Evaluater.Cddr(lispObject4) != NIL) {
                    throw new LispException("EVAL/APPLY: bad &REST parameter: " + lispObject);
                }
                environment = Evaluater.MakeCons(Evaluater.MakeCons(Evaluater.Cadr(lispObject4), lispObject3), environment);
                return;
            }
            if (!Evaluater.Symbolp(Evaluater.Car(lispObject4))) {
                throw new LispException("EVAL/APPLY: non-symbol in formal parameter list: " + lispObject);
            }
            if (lispObject3 == NIL) {
                throw new LispException("EVAL/APPLY: actual argument list is too short: " + lispObject2);
            }
            if (!Evaluater.Consp(lispObject3)) {
                throw new LispException("EVAL/APPLY: actual argument list is dotted: " + lispObject2);
            }
            environment = Evaluater.MakeCons(Evaluater.MakeCons(Evaluater.Car(lispObject4), Evaluater.Car(lispObject3)), environment);
            lispObject4 = Evaluater.Cdr(lispObject4);
            lispObject3 = Evaluater.Cdr(lispObject3);
        }
        if (lispObject3 != NIL) {
            throw new LispException("EVAL/APPLY: actual argument list is too long: " + lispObject2);
        }
        if (lispObject4 != NIL) {
            throw new LispException("EVAL/APPLY: formal argument list is dotted: ", lispObject);
        }
    }

    public LispObject BindingReference(Symbol symbol) throws LispException {
        LispObject lispObject = environment;
        while (Evaluater.Consp(lispObject)) {
            if (symbol == Evaluater.Caar(lispObject)) {
                return Evaluater.Car(lispObject);
            }
            lispObject = Evaluater.Cdr(lispObject);
        }
        return symbol;
    }

    public LispObject EvalArgs(LispObject lispObject) throws LispException {
        LispObject lispObject2 = NIL;
        LispObject lispObject3 = NIL;
        while (Evaluater.Consp(lispObject)) {
            if (lispObject2 == NIL) {
                lispObject2 = lispObject3 = Evaluater.MakeCons(this.EvalSexpr(Evaluater.Car(lispObject)), NIL);
                Evaluater.Preserve(lispObject2);
            } else {
                Evaluater.CvtToCons(lispObject3).SetCdr(Evaluater.MakeCons(this.EvalSexpr(Evaluater.Car(lispObject)), NIL));
                lispObject3 = Evaluater.Cdr(lispObject3);
            }
            lispObject = Evaluater.Cdr(lispObject);
        }
        if (lispObject != NIL) {
            throw new LispException("EVAL: argument list is not a proper list");
        }
        if (lispObject2 != NIL) {
            Evaluater.Release();
        }
        return lispObject2;
    }

    public LispObject EvalSexpr(LispObject lispObject) throws LispException {
        if (Evaluater.DebugMode()) {
            Evaluater.DebugPrint("Evaluating " + lispObject + " in environment " + environment);
        }
        if (Evaluater.Symbolp(lispObject)) {
            LispObject lispObject2 = this.BindingReference(Evaluater.CvtToSymbol(lispObject));
            if (lispObject2 == lispObject) {
                if (Evaluater.CvtToSymbol(lispObject).GetValue() != null) {
                    return Evaluater.CvtToSymbol(lispObject).GetValue();
                }
                throw new LispException("EVAL: no value binding " + lispObject);
            }
            return Evaluater.Cdr(lispObject2);
        }
        if (!Evaluater.Consp(lispObject)) {
            return lispObject;
        }
        if (Evaluater.Consp(Evaluater.Car(lispObject))) {
            LispObject lispObject3 = Evaluater.Car(lispObject);
            if (Evaluater.Car(lispObject3) != LAMBDA) {
                throw new LispException("EVAL: CAR of list is not a function: " + lispObject);
            }
            if (!Evaluater.Consp(Evaluater.Cdr(lispObject3)) || !Evaluater.Listp(Evaluater.Cadr(lispObject3))) {
                throw new LispException("EVAL: malformed LAMBDA: " + lispObject3);
            }
            Cons cons = Evaluater.MakeCons(LAMBDA_CLOSURE, Evaluater.MakeCons(environment, Evaluater.Cdr(lispObject3)));
            Evaluater.Preserve(cons);
            LispObject lispObject4 = this.Apply(cons, this.EvalArgs(Evaluater.Cdr(lispObject)));
            Evaluater.Release();
            return lispObject4;
        }
        if (!Evaluater.Symbolp(Evaluater.Car(lispObject))) {
            throw new LispException("EVAL: CAR of list is not a function: " + lispObject);
        }
        LispObject lispObject5 = Evaluater.CvtToSymbol(Evaluater.Car(lispObject)).GetFunction();
        if (lispObject5 == null) {
            throw new LispException("EVAL: no function binding: ", Evaluater.Car(lispObject));
        }
        Evaluater.Preserve(lispObject5);
        if (Evaluater.Builtinp(lispObject5)) {
            if (Evaluater.CvtToBuiltin(lispObject5).GetSpecial()) {
                Evaluater.Preserve(Evaluater.Cdr(lispObject));
                LispObject lispObject6 = Evaluater.CvtToBuiltin(lispObject5).Call(Evaluater.Cdr(lispObject));
                Evaluater.Release();
                Evaluater.Release();
                return lispObject6;
            }
            LispObject lispObject7 = this.Apply(lispObject5, this.EvalArgs(Evaluater.Cdr(lispObject)));
            Evaluater.Release();
            return lispObject7;
        }
        if (Evaluater.Consp(lispObject5) && Evaluater.Car(lispObject5) == MACRO) {
            LispObject lispObject8 = this.MacroExpand1(lispObject);
            Evaluater.Release();
            Evaluater.Preserve(lispObject8);
            lispObject8 = this.EvalSexpr(lispObject8);
            Evaluater.Release();
            return lispObject8;
        }
        if (Evaluater.Consp(lispObject5) && Evaluater.Car(lispObject5) == LAMBDA_CLOSURE) {
            LispObject lispObject9 = this.Apply(lispObject5, this.EvalArgs(Evaluater.Cdr(lispObject)));
            Evaluater.Release();
            return lispObject9;
        }
        throw new LispException("EVAL: invalid function binding: ", Evaluater.Car(lispObject));
    }

    public LispObject Progn(LispObject lispObject) throws LispException {
        LispObject lispObject2 = NIL;
        while (Evaluater.Consp(lispObject)) {
            lispObject2 = this.EvalSexpr(Evaluater.Car(lispObject));
            lispObject = Evaluater.Cdr(lispObject);
        }
        if (lispObject != NIL) {
            throw new LispException("PROGN: argument list is not a proper list: ", lispObject);
        }
        return lispObject2;
    }

    public LispObject MacroExpand1(LispObject lispObject) throws LispException {
        LispObject lispObject2;
        if (!(Evaluater.Consp(lispObject) && Evaluater.Symbolp(Evaluater.Car(lispObject)) && null != (lispObject2 = Evaluater.CvtToSymbol(Evaluater.Car(lispObject)).GetFunction()) && Evaluater.Consp(lispObject2) && Evaluater.Car(lispObject2) == MACRO)) {
            return lispObject;
        }
        Evaluater.Preserve(lispObject2);
        Evaluater.Preserve(environment);
        environment = NIL;
        this.BindArgs(Evaluater.Cadr(lispObject2), Evaluater.Cdr(lispObject));
        LispObject lispObject3 = this.Progn(Evaluater.Cddr(lispObject2));
        environment = Evaluater.Release();
        Evaluater.Release();
        return lispObject3;
    }
}

