/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringWriter;
import java.net.URL;

public class Lisp51
extends Applet {
    private Lisp51UI.VerticalLabel listenerLabel;
    private Lisp51UI.VerticalLabel displayLabel;
    private Lisp51UI.VerticalLabel errorsLabel;
    private Checkbox evaluateMode;
    private boolean interactive;
    private Button evaluate;
    private Button clear;
    private TextArea listener;
    private TextArea display;
    private TextArea errors;
    private String lastText;
    private Parser parser;
    private Evaluater evaluater;
    private Loader loader;
    private Primitive prims;
    private volatile Thread gcThread;
    private Font plainFont;
    private Font boldFont;
    private Font italicFont;
    public String baseDocumentName;
    public boolean runAsApplet = true;

    public static void main(String[] stringArray) {
        Frame frame = new Frame("JLisp51");
        Lisp51 lisp51 = new Lisp51();
        lisp51.runAsApplet = false;
        frame.add((Component)lisp51, "Center");
        lisp51.init();
        lisp51.start();
        frame.pack();
        frame.show();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    public void init() {
        if (this.runAsApplet) {
            this.useParameters();
        }
        this.CreateSystemObjects();
        this.SetUpUIAndControls();
        this.loader.Load("init.lisp");
    }

    private void useParameters() {
        URL uRL = null;
        try {
            uRL = this.getDocumentBase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRL != null) {
            this.baseDocumentName = uRL.toString();
        }
    }

    private void CreateSystemObjects() {
        this.parser = new Parser();
        this.evaluater = new Evaluater();
        this.loader = new Loader(this, this.parser, this.evaluater);
        this.prims = new Primitive(this.evaluater);
    }

    private void SetUpUIAndControls() {
        this.plainFont = new Font("Monospaced", 0, 12);
        this.boldFont = new Font("Monospaced", 1, 12);
        this.italicFont = new Font("Monospaced", 2, 12);
        this.lastText = "";
        this.listener = new TextArea("", 10, 74, 1);
        this.listenerLabel = new Lisp51UI.VerticalLabel("Lisp Listener", new Font("monospaced", 1, 9));
        this.listener.setBackground(Color.black);
        this.listener.setForeground(Color.green);
        this.listener.setFont(this.plainFont);
        this.AddKeyHandler();
        this.display = new TextArea("", 5, 74, 1);
        this.displayLabel = new Lisp51UI.VerticalLabel("Ev. Results", new Font("monospaced", 0, 9));
        this.display.setBackground(Color.black);
        this.display.setForeground(Color.green);
        this.display.setFont(this.boldFont);
        this.display.setEditable(false);
        this.errors = new TextArea("", 3, 74, 1);
        this.errorsLabel = new Lisp51UI.VerticalLabel("Errors", new Font("monospaced", 1, 9));
        this.errors.setBackground(Color.black);
        this.errors.setForeground(Color.green);
        this.errors.setFont(this.italicFont);
        this.errors.setEditable(false);
        this.evaluate = new Button("Evaluate");
        this.clear = new Button("Clear");
        this.AddButtonHandler();
        this.interactive = true;
        this.evaluateMode = new Checkbox("Interactive mode?", true);
        this.AddCheckboxHandler();
        this.setBackground(Color.white);
        this.prims.SetDisplay(this.display);
        this.prims.SetErrors(this.errors);
        this.prims.SetLoader(this.loader);
        this.loader.SetErrors(this.errors);
        this.DoLayout();
    }

    private void DoLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.listenerLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.listener, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.evaluateMode, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.evaluate, gridBagConstraints);
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.clear, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.displayLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.display, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.errorsLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.errors, gridBagConstraints);
    }

    private void AddButtonHandler() {
        this.evaluate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Lisp51.this.interactive) {
                    return;
                }
                Lisp51.this.listener.selectAll();
                String string = Lisp51.this.listener.getText();
                try {
                    Lisp51.this.TopLevel(string);
                }
                catch (LispException lispException) {
                    System.out.println(lispException.getMessage());
                }
                Lisp51.this.listener.requestFocus();
            }
        });
        this.clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Lisp51.this.lastText = "";
                Lisp51.this.listener.setText("");
                Lisp51.this.display.setText("");
                Lisp51.this.errors.setText("");
            }
        });
    }

    private void AddCheckboxHandler() {
        this.evaluateMode.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!Lisp51.this.interactive) {
                    Lisp51.this.lastText = "";
                }
                Lisp51.this.interactive = !Lisp51.this.interactive;
            }
        });
    }

    private void AddKeyHandler() {
        this.listener.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (Lisp51.this.interactive && keyEvent.getKeyCode() == 10) {
                    int n = Lisp51.this.listener.getCaretPosition();
                    String string = Lisp51.this.listener.getText() + " ";
                    String string2 = Lisp51.this.getNewText(Lisp51.this.lastText, string);
                    try {
                        if (!Lisp51.this.parser.CheckSexpr(new LispStringReader(string2))) {
                            Lisp51.this.listener.setText(string);
                            Lisp51.this.listener.setCaretPosition(n + 1);
                            return;
                        }
                    }
                    catch (LispException lispException) {
                        System.out.println(lispException.getMessage());
                    }
                    Lisp51.this.lastText = string;
                    try {
                        Lisp51.this.TopLevel(string2);
                    }
                    catch (LispException lispException) {
                        System.out.println(lispException.getMessage());
                    }
                    Lisp51.this.listener.setText(string);
                    Lisp51.this.listener.setCaretPosition(n + 1);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void TopLevel(String string) throws LispException {
        Object object = Lisp51ToolKit.gcLock;
        synchronized (object) {
            LispObject lispObject = Lisp51ToolKit.environment;
            Lisp51ToolKit.Preserve(lispObject);
            try {
                try {
                    LispStringReader lispStringReader = new LispStringReader(string);
                    LispObject lispObject2 = null;
                    while ((lispObject2 = this.parser.ReadSexpr(lispStringReader)) != null) {
                        Lisp51ToolKit.Preserve(lispObject2);
                        LispObject lispObject3 = this.evaluater.EvalSexpr(lispObject2);
                        Lisp51ToolKit.Release();
                        StringWriter stringWriter = new StringWriter();
                        lispObject3.Print(stringWriter);
                        String string2 = stringWriter.toString();
                        this.display.append("\n");
                        this.display.append("==> " + string2);
                        this.display.append("\n");
                    }
                    Object var10_13 = null;
                }
                catch (LispException lispException) {
                    Lisp51ToolKit.environment = lispObject;
                    this.errors.append(lispException.getMessage());
                    StringWriter stringWriter = new StringWriter();
                    LispObject lispObject4 = lispException.GetObject();
                    if (lispObject4 != null) {
                        lispObject4.Print(stringWriter);
                    }
                    this.errors.append(" " + stringWriter.toString());
                    this.errors.append("\n");
                    Object var10_14 = null;
                    while (!Lisp51ToolKit.preserveStack.isEmpty() && Lisp51ToolKit.preserveStack.peek() != lispObject) {
                        Lisp51ToolKit.Release();
                    }
                    if (!Lisp51ToolKit.preserveStack.isEmpty()) return;
                    throw new LispException("Unrecoverable Error: Preserve Stack corrupted");
                }
                catch (Exception exception) {
                    Lisp51ToolKit.environment = lispObject;
                    this.errors.append("JavaException: " + exception);
                    Object var10_15 = null;
                    while (!Lisp51ToolKit.preserveStack.isEmpty() && Lisp51ToolKit.preserveStack.peek() != lispObject) {
                        Lisp51ToolKit.Release();
                    }
                    if (!Lisp51ToolKit.preserveStack.isEmpty()) return;
                    throw new LispException("Unrecoverable Error: Preserve Stack corrupted");
                }
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                while (!Lisp51ToolKit.preserveStack.isEmpty() && Lisp51ToolKit.preserveStack.peek() != lispObject) {
                    Lisp51ToolKit.Release();
                }
                if (!Lisp51ToolKit.preserveStack.isEmpty()) throw throwable;
                throw new LispException("Unrecoverable Error: Preserve Stack corrupted");
            }
            while (!Lisp51ToolKit.preserveStack.isEmpty() && Lisp51ToolKit.preserveStack.peek() != lispObject) {
                Lisp51ToolKit.Release();
            }
            if (!Lisp51ToolKit.preserveStack.isEmpty()) return;
            throw new LispException("Unrecoverable Error: Preserve Stack corrupted");
        }
    }

    public void start() {
        class GcThreadType
        extends Thread {
            GcThreadType() {
            }

            public void run() {
                Thread thread = Thread.currentThread();
                while (thread == Lisp51.this.gcThread) {
                    try {
                        GcThreadType.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    long l = Lisp51ToolKit.GC();
                    if (!Lisp51ToolKit.DebugMode() || l <= 0L) continue;
                    System.out.println("GC count: " + l);
                }
            }
        }
        this.gcThread = new GcThreadType();
        this.gcThread.setName("GC Thread");
        this.gcThread.setPriority(4);
        this.gcThread.start();
    }

    public void stop() {
        this.gcThread = null;
    }

    public void destroy() {
        this.gcThread = null;
    }

    private String getNewText(String string, String string2) {
        int n;
        int n2 = string.length();
        int n3 = string2.length();
        for (n = 0; n < n2 && n < n3 && string.charAt(n) == string2.charAt(n); ++n) {
        }
        return string2.substring(n, n3);
    }
}

