/*
 * Decompiled with CFR 0.152.
 */
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class Lisp51ToolKit {
    public static Stack preserveStack;
    public static Hashtable symbolTable;
    public static LispObject environment;
    public static Object gcLock;
    public static Symbol NIL;
    public static Symbol T;
    public static Symbol LAMBDA;
    public static Symbol LAMBDA_CLOSURE;
    public static Symbol FUNCTION;
    public static Symbol QUOTE;
    public static Symbol BACKQUOTE;
    public static Symbol COMMA;
    public static Symbol COMMA_AT;
    public static Symbol REST;
    public static Symbol TEST;
    public static Symbol MACRO;
    public static Symbol DEBUG;
    public static Symbol DEBUG_MODE;
    public static Symbol DEBUG_GC;
    private static int gcCount;
    private static int gcLimit;

    public static int GetGCCount() {
        return gcCount;
    }

    public static int GetGCLimit() {
        return gcLimit;
    }

    public static void SetGCCount(int n) {
        gcCount = n;
    }

    public static void SetGCLimit(int n) {
        gcLimit = n;
    }

    public static final void PreserveAllExistingObjects() {
        Lisp51ToolKit.Preserve(NIL);
        Lisp51ToolKit.Preserve(T);
        Lisp51ToolKit.Preserve(LAMBDA);
        Lisp51ToolKit.Preserve(LAMBDA_CLOSURE);
        Lisp51ToolKit.Preserve(FUNCTION);
        Lisp51ToolKit.Preserve(QUOTE);
        Lisp51ToolKit.Preserve(BACKQUOTE);
        Lisp51ToolKit.Preserve(COMMA);
        Lisp51ToolKit.Preserve(COMMA_AT);
        Lisp51ToolKit.Preserve(REST);
        Lisp51ToolKit.Preserve(TEST);
        Lisp51ToolKit.Preserve(MACRO);
        Lisp51ToolKit.Preserve(DEBUG);
        Lisp51ToolKit.Preserve(DEBUG_MODE);
        Lisp51ToolKit.Preserve(DEBUG_GC);
    }

    public static boolean DebugMode() {
        return DEBUG_MODE.GetValue() != NIL;
    }

    public static void DebugPrint(String string) {
        System.out.println(string);
    }

    public static boolean DebugGC() {
        return DEBUG_GC.GetValue() != NIL;
    }

    public static Symbol MakeSymbol(String string) {
        try {
            Symbol symbol;
            Lisp51ToolKit.MaybeGC();
            LispObject lispObject = (LispObject)symbolTable.get(string);
            if (lispObject != null) {
                return Lisp51ToolKit.CvtToSymbol(lispObject);
            }
            if (Symbol.freeList == null) {
                symbol = new Symbol();
                symbol.SetName(string);
            } else {
                symbol = Lisp51ToolKit.CvtToSymbol(Symbol.freeList);
                Symbol.freeList = Symbol.freeList.link;
                symbol.SetName(string);
                symbol.link = LispObject.usedList;
                LispObject.usedList = symbol;
            }
            symbol.SetValue(null);
            symbol.SetFunction(null);
            symbol.SetPlist(NIL);
            symbolTable.put(string, symbol);
            return symbol;
        }
        catch (LispException lispException) {
            return null;
        }
    }

    public static Fixnum MakeFixnum(long l) {
        try {
            Fixnum fixnum;
            Lisp51ToolKit.MaybeGC();
            if (Fixnum.freeList == null) {
                fixnum = new Fixnum();
                fixnum.SetValue(l);
            } else {
                fixnum = Lisp51ToolKit.CvtToFixnum(Fixnum.freeList);
                Fixnum.freeList = Fixnum.freeList.link;
                fixnum.SetValue(l);
                fixnum.link = LispObject.usedList;
                LispObject.usedList = fixnum;
            }
            return fixnum;
        }
        catch (LispException lispException) {
            return null;
        }
    }

    public static Cons MakeCons(LispObject lispObject, LispObject lispObject2) {
        try {
            Cons cons;
            Lisp51ToolKit.Preserve(lispObject);
            Lisp51ToolKit.Preserve(lispObject2);
            Lisp51ToolKit.MaybeGC();
            if (Cons.freeList == null) {
                cons = new Cons();
                cons.SetCar(lispObject);
                cons.SetCdr(lispObject2);
            } else {
                cons = Lisp51ToolKit.CvtToCons(Cons.freeList);
                Cons.freeList = Cons.freeList.link;
                cons.SetCar(lispObject);
                cons.SetCdr(lispObject2);
                cons.link = LispObject.usedList;
                LispObject.usedList = cons;
            }
            Lisp51ToolKit.Release();
            Lisp51ToolKit.Release();
            return cons;
        }
        catch (LispException lispException) {
            return null;
        }
    }

    public static Builtin MakeBuiltin(String string, Callable callable, boolean bl) {
        try {
            Builtin builtin;
            Lisp51ToolKit.MaybeGC();
            if (Builtin.freeList == null) {
                builtin = new Builtin(string, callable, bl);
            } else {
                builtin = Lisp51ToolKit.CvtToBuiltin(Builtin.freeList);
                Builtin.freeList = Builtin.freeList.link;
                builtin.SetName(string);
                builtin.SetCode(callable);
                builtin.SetSpecial(bl);
                builtin.link = LispObject.usedList;
                LispObject.usedList = builtin;
            }
            return builtin;
        }
        catch (LispException lispException) {
            return null;
        }
    }

    public static LispString MakeString(String string) {
        try {
            LispString lispString;
            Lisp51ToolKit.MaybeGC();
            if (LispString.freeList == null) {
                lispString = new LispString();
                lispString.SetString(string);
            } else {
                lispString = Lisp51ToolKit.CvtToLispString(LispString.freeList);
                LispString.freeList = LispString.freeList.link;
                lispString.SetString(string);
                lispString.link = LispObject.usedList;
                LispObject.usedList = lispString;
            }
            return lispString;
        }
        catch (LispException lispException) {
            return null;
        }
    }

    public static LispArray MakeArray(int[] nArray) {
        try {
            LispArray lispArray;
            Lisp51ToolKit.MaybeGC();
            if (LispArray.freeList == null) {
                lispArray = new LispArray(nArray);
            } else {
                lispArray = Lisp51ToolKit.CvtToLispArray(LispArray.freeList);
                LispArray.freeList = LispArray.freeList.link;
                lispArray.SetDimensions(nArray);
                lispArray.SetRank(nArray.length);
                int n = 1;
                int n2 = 0;
                while (n2 < nArray.length) {
                    n *= nArray[n2++];
                }
                LispObject[] lispObjectArray = new LispObject[n];
                for (int i = 0; i < n; ++i) {
                    lispObjectArray[i] = NIL;
                }
                lispArray.SetContents(lispObjectArray);
            }
            return lispArray;
        }
        catch (LispException lispException) {
            return null;
        }
    }

    public static final void Preserve(LispObject lispObject) {
        preserveStack.push(lispObject);
    }

    public static final LispObject Release() throws LispException {
        LispObject lispObject = null;
        try {
            lispObject = (LispObject)preserveStack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            throw new LispException("GC: popping from empty preserveStack");
        }
        return lispObject;
    }

    private static long MaybeGC() {
        if (++gcCount >= gcLimit) {
            gcCount = 0;
            return Lisp51ToolKit.GC();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long GC() {
        Object object = gcLock;
        synchronized (object) {
            if (Lisp51ToolKit.DebugMode()) {
                System.out.println("Before GC");
                Lisp51ToolKit.GCStats();
            }
            Lisp51ToolKit.GCMark();
            long l = Lisp51ToolKit.GCSweep();
            if (Lisp51ToolKit.DebugMode()) {
                System.out.println("After GC");
                Lisp51ToolKit.GCStats();
            }
            return l;
        }
    }

    private static final void GCMark() {
        LispObject lispObject = LispObject.usedList;
        lispObject = LispObject.usedList;
        while (lispObject != null) {
            lispObject.marked = false;
            lispObject = lispObject.link;
        }
        environment.Mark();
        Enumeration<Object> enumeration = preserveStack.elements();
        lispObject = null;
        while (enumeration.hasMoreElements()) {
            lispObject = (LispObject)enumeration.nextElement();
            lispObject.Mark();
        }
        enumeration = symbolTable.elements();
        Symbol symbol = null;
        while (enumeration.hasMoreElements()) {
            symbol = (Symbol)enumeration.nextElement();
            if (symbol.GetPlist() == NIL && symbol.GetValue() == null && symbol.GetFunction() == null) continue;
            symbol.Mark();
        }
    }

    private static final long GCSweep() {
        long l = 0L;
        try {
            LispObject lispObject = LispObject.usedList;
            LispObject lispObject2 = null;
            while (lispObject != null) {
                LispObject lispObject3 = null;
                LispObject lispObject4 = lispObject.link;
                if (!lispObject.marked) {
                    if (Lisp51ToolKit.DebugGC()) {
                        Lisp51ToolKit.DebugPrint("Sweeping " + lispObject);
                    }
                    if (Lisp51ToolKit.Symbolp(lispObject)) {
                        symbolTable.remove(Lisp51ToolKit.CvtToSymbol(lispObject).GetName());
                    }
                    ++l;
                    lispObject.link = lispObject3 = lispObject.GetFreeList();
                    lispObject.SetFreeList(lispObject);
                    if (lispObject2 == null) {
                        LispObject.usedList = lispObject4;
                        lispObject = lispObject4;
                        continue;
                    }
                    lispObject2.link = lispObject4;
                    lispObject = lispObject4;
                    continue;
                }
                lispObject2 = lispObject;
                lispObject = lispObject4;
            }
        }
        catch (LispException lispException) {
            // empty catch block
        }
        return l;
    }

    private static void GCStats() {
        long l = 0L;
        LispObject lispObject = LispObject.usedList;
        while (lispObject != null) {
            ++l;
            lispObject = lispObject.link;
        }
        System.out.println("UsedList: " + l + " objects.");
        l = 0L;
        lispObject = Symbol.freeList;
        while (lispObject != null) {
            ++l;
            lispObject = lispObject.link;
        }
        System.out.println("Symbol.freeList: " + l + " objects.");
        l = 0L;
        lispObject = Fixnum.freeList;
        while (lispObject != null) {
            ++l;
            lispObject = lispObject.link;
        }
        System.out.println("Fixnum.freeList: " + l + " objects.");
        l = 0L;
        lispObject = Builtin.freeList;
        while (lispObject != null) {
            ++l;
            lispObject = lispObject.link;
        }
        System.out.println("Builtin.freeList: " + l + " objects.");
        l = 0L;
        lispObject = LispString.freeList;
        while (lispObject != null) {
            ++l;
            lispObject = lispObject.link;
        }
        System.out.println("String.freeList: " + l + " objects.");
        l = 0L;
        lispObject = Cons.freeList;
        while (lispObject != null) {
            ++l;
            lispObject = lispObject.link;
        }
        System.out.println("Cons.freeList: " + l + " objects.");
        l = 0L;
        lispObject = LispArray.freeList;
        while (lispObject != null) {
            ++l;
            lispObject = lispObject.link;
        }
        System.out.println("LispArray.freeList: " + l + " object.");
        l = 0L;
    }

    public static boolean Consp(LispObject lispObject) {
        return lispObject instanceof Cons;
    }

    public static boolean Symbolp(LispObject lispObject) {
        return lispObject instanceof Symbol;
    }

    public static boolean Fixnump(LispObject lispObject) {
        return lispObject instanceof Fixnum;
    }

    public static boolean Builtinp(LispObject lispObject) {
        return lispObject instanceof Builtin;
    }

    public static boolean LispStringp(LispObject lispObject) {
        return lispObject instanceof LispString;
    }

    public static boolean Listp(LispObject lispObject) {
        return lispObject instanceof Cons || lispObject == NIL;
    }

    public static boolean LispArrayp(LispObject lispObject) {
        return lispObject instanceof LispArray;
    }

    public static Cons CvtToCons(LispObject lispObject) throws LispException {
        if (Lisp51ToolKit.Consp(lispObject)) {
            return (Cons)lispObject;
        }
        throw new LispException("Cannot convert to CONS:", lispObject);
    }

    public static Symbol CvtToSymbol(LispObject lispObject) throws LispException {
        if (Lisp51ToolKit.Symbolp(lispObject)) {
            return (Symbol)lispObject;
        }
        throw new LispException("Cannot convert to SYMBOL:", lispObject);
    }

    public static Fixnum CvtToFixnum(LispObject lispObject) throws LispException {
        if (Lisp51ToolKit.Fixnump(lispObject)) {
            return (Fixnum)lispObject;
        }
        throw new LispException("Cannot convert to FIXNUM:", lispObject);
    }

    public static Builtin CvtToBuiltin(LispObject lispObject) throws LispException {
        if (Lisp51ToolKit.Builtinp(lispObject)) {
            return (Builtin)lispObject;
        }
        throw new LispException("Cannot convert to BUILTIN:", lispObject);
    }

    public static LispString CvtToLispString(LispObject lispObject) throws LispException {
        if (Lisp51ToolKit.LispStringp(lispObject)) {
            return (LispString)lispObject;
        }
        throw new LispException("Cannot convert to LISPSTRING:", lispObject);
    }

    public static LispArray CvtToLispArray(LispObject lispObject) throws LispException {
        if (Lisp51ToolKit.LispArrayp(lispObject)) {
            return (LispArray)lispObject;
        }
        throw new LispException("Cannot convert to LISPARRAY:", lispObject);
    }

    public static LispObject Car(LispObject lispObject) throws LispException {
        if (lispObject == NIL) {
            return NIL;
        }
        return Lisp51ToolKit.CvtToCons(lispObject).GetCar();
    }

    public static LispObject Cdr(LispObject lispObject) throws LispException {
        if (lispObject == NIL) {
            return NIL;
        }
        return Lisp51ToolKit.CvtToCons(lispObject).GetCdr();
    }

    public static LispObject Rplaca(LispObject lispObject, LispObject lispObject2) throws LispException {
        if (!Lisp51ToolKit.Consp(lispObject)) {
            return NIL;
        }
        Lisp51ToolKit.CvtToCons(lispObject).SetCar(lispObject2);
        return lispObject;
    }

    public static LispObject Rplacd(LispObject lispObject, LispObject lispObject2) throws LispException {
        if (!Lisp51ToolKit.Consp(lispObject)) {
            return NIL;
        }
        Lisp51ToolKit.CvtToCons(lispObject).SetCdr(lispObject2);
        return lispObject;
    }

    public static LispObject Caar(LispObject lispObject) throws LispException {
        return Lisp51ToolKit.Car(Lisp51ToolKit.Car(lispObject));
    }

    public static LispObject Cadr(LispObject lispObject) throws LispException {
        return Lisp51ToolKit.Car(Lisp51ToolKit.Cdr(lispObject));
    }

    public static LispObject Cdar(LispObject lispObject) throws LispException {
        return Lisp51ToolKit.Cdr(Lisp51ToolKit.Car(lispObject));
    }

    public static LispObject Cddr(LispObject lispObject) throws LispException {
        return Lisp51ToolKit.Cdr(Lisp51ToolKit.Cdr(lispObject));
    }

    public static LispObject Cadar(LispObject lispObject) throws LispException {
        return Lisp51ToolKit.Car(Lisp51ToolKit.Cdr(Lisp51ToolKit.Car(lispObject)));
    }

    public static LispObject Caddr(LispObject lispObject) throws LispException {
        return Lisp51ToolKit.Car(Lisp51ToolKit.Cddr(lispObject));
    }

    public static LispObject Cddar(LispObject lispObject) throws LispException {
        return Lisp51ToolKit.Cdr(Lisp51ToolKit.Cdr(Lisp51ToolKit.Car(lispObject)));
    }

    public static LispObject Cdddr(LispObject lispObject) throws LispException {
        return Lisp51ToolKit.Cdr(Lisp51ToolKit.Cdr(Lisp51ToolKit.Cdr(lispObject)));
    }

    static {
        gcCount = 0;
        gcLimit = 1000;
        preserveStack = new Stack();
        symbolTable = new Hashtable();
        gcLock = new Object();
        NIL = new Symbol("NIL", null, null, null);
        NIL.SetValue(NIL);
        NIL.SetPlist(NIL);
        environment = NIL;
        T = new Symbol("T", null, null, NIL);
        T.SetValue(T);
        TEST = new Symbol(":TEST", null, null, NIL);
        TEST.SetValue(TEST);
        REST = new Symbol("&REST", null, null, NIL);
        REST.SetValue(REST);
        LAMBDA = new Symbol("LAMBDA", null, null, NIL);
        LAMBDA_CLOSURE = new Symbol("LAMBDA-CLOSURE", null, null, NIL);
        MACRO = new Symbol("MACRO", null, null, NIL);
        FUNCTION = new Symbol("FUNCTION", null, null, NIL);
        QUOTE = new Symbol("QUOTE", null, null, NIL);
        BACKQUOTE = new Symbol("BACKQUOTE", null, null, NIL);
        COMMA = new Symbol("COMMA", null, null, NIL);
        COMMA_AT = new Symbol("COMMA-AT", null, null, NIL);
        DEBUG = new Symbol("DEBUG", null, null, NIL);
        DEBUG.SetValue(NIL);
        DEBUG_MODE = new Symbol("*DEBUG-MODE*", null, null, NIL);
        DEBUG_MODE.SetValue(NIL);
        DEBUG_GC = new Symbol("*DEBUG-GC*", null, null, NIL);
        DEBUG_GC.SetValue(NIL);
        Lisp51ToolKit.PreserveAllExistingObjects();
    }
}

