/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;

public class Lisp51UI {

    public static class VerticalLabel
    extends Canvas {
        private String text;
        private int width;
        private Font displayFont;
        private FontMetrics fm;

        public VerticalLabel(String string, Font font) {
            this.text = string;
            this.displayFont = font;
            this.width = 0;
            this.fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
            this.setBackground(Color.white);
        }

        public Dimension getPreferredSize() {
            int n = this.fm.charWidth('W') * 3;
            int n2 = this.fm.getHeight() * this.text.length() + this.fm.getHeight() * 2;
            return new Dimension(n, n2);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics graphics) {
            if (this.width == 0) {
                this.width = this.getSize().width;
            }
            graphics.setFont(this.displayFont);
            int n = this.fm.getAscent();
            int n2 = this.fm.getHeight();
            int n3 = this.text.length();
            int n4 = n;
            for (int i = 0; i < n3; ++i) {
                Character c = new Character(this.text.charAt(i));
                String string = c.toString();
                int n5 = (this.width - this.fm.stringWidth(c.toString())) / 2;
                graphics.drawString(string, n5, n4);
                n4 += n;
            }
        }
    }
}

