/*
 * Decompiled with CFR 0.152.
 */
import java.io.StringWriter;

public class LispArray
extends LispObject {
    private LispObject[] contents;
    private int rank;
    private int[] dimensions;
    public static LispObject freeList = null;

    public LispArray(int[] nArray) {
        this.dimensions = nArray;
        this.rank = nArray.length;
        int n = 1;
        int n2 = 0;
        while (n2 < this.rank) {
            n *= nArray[n2++];
        }
        this.contents = new LispObject[n];
        for (n2 = 0; n2 < n; ++n2) {
            this.contents[n2] = NIL;
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        this.Print(stringWriter);
        return stringWriter.toString();
    }

    public void Print(StringWriter stringWriter) {
        try {
            stringWriter.write(35);
            stringWriter.write("" + this.rank);
            int[] nArray = new int[this.rank];
            for (int i = 0; i < this.rank; ++i) {
                nArray[i] = 0;
            }
            this.PrintElements(stringWriter, 0, nArray);
        }
        catch (LispException lispException) {
            // empty catch block
        }
    }

    private void PrintElements(StringWriter stringWriter, int n, int[] nArray) throws LispException {
        if (n == this.rank - 1) {
            stringWriter.write(40);
            nArray[n] = 0;
            while (nArray[n] < this.dimensions[n]) {
                int n2 = this.CalculateOffset(nArray);
                this.contents[n2].Print(stringWriter);
                if (nArray[n] != this.dimensions[n] - 1) {
                    stringWriter.write(32);
                }
                int n3 = n;
                nArray[n3] = nArray[n3] + 1;
            }
            stringWriter.write(41);
            return;
        }
        stringWriter.write(40);
        nArray[n] = 0;
        while (nArray[n] < this.dimensions[n]) {
            this.PrintElements(stringWriter, n + 1, nArray);
            if (nArray[n] != this.dimensions[n] - 1) {
                stringWriter.write(32);
            }
            int n4 = n;
            nArray[n4] = nArray[n4] + 1;
        }
        stringWriter.write(41);
    }

    public void Mark() {
        if (this.marked) {
            return;
        }
        this.marked = true;
        for (int i = 0; i < this.contents.length; ++i) {
            this.contents[i].Mark();
        }
    }

    public LispObject GetFreeList() {
        return freeList;
    }

    public void SetFreeList(LispObject lispObject) {
        freeList = lispObject;
    }

    public LispObject[] GetContents() {
        return this.contents;
    }

    public int GetRank() {
        return this.rank;
    }

    public int[] GetDimensions() {
        return this.dimensions;
    }

    public LispObject GetElementAt(int[] nArray) throws LispException {
        int n = this.CalculateOffset(nArray);
        return this.contents[n];
    }

    public void SetContents(LispObject[] lispObjectArray) {
        this.contents = lispObjectArray;
    }

    public void SetRank(int n) {
        this.rank = n;
    }

    public void SetDimensions(int[] nArray) {
        this.dimensions = nArray;
    }

    public void SetElementAt(int[] nArray, LispObject lispObject) throws LispException {
        int n = this.CalculateOffset(nArray);
        this.contents[n] = lispObject;
    }

    int CalculateOffset(int[] nArray) throws LispException {
        int n = nArray.length;
        if (n != this.rank) {
            throw new LispException("AREF: Array reference incompatible with array dimensions: " + this);
        }
        int n2 = 0;
        for (int i = n - 1; i > -1; --i) {
            if (nArray[i] >= this.dimensions[i]) {
                throw new LispException("AREF: Array reference out of bounds: " + this + "\n" + nArray);
            }
            if (i == n - 1) {
                n2 = nArray[i];
                continue;
            }
            n2 += nArray[i] * this.dimensions[i + 1];
        }
        return n2;
    }
}

