/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.StringReader;

class LispStringReader
extends StringReader {
    private static int lastChar;
    private boolean backup = false;

    public LispStringReader(String string) {
        super(string);
    }

    public int read() throws IOException {
        if (this.backup) {
            this.backup = false;
            return lastChar;
        }
        lastChar = super.read();
        return lastChar;
    }

    public void unread() throws LispException {
        if (this.backup) {
            throw new LispException("READ: cannot push back into string");
        }
        this.backup = true;
    }

    public int peek() throws IOException {
        if (!this.backup) {
            this.backup = true;
            lastChar = super.read();
            return lastChar;
        }
        return lastChar;
    }
}

