/*
 * Decompiled with CFR 0.152.
 */
import java.awt.TextArea;

public class Primitive
extends Lisp51ToolKit {
    Evaluater evaluater;
    Loader loader;
    TextArea display;
    TextArea errors;

    public void SetDisplay(TextArea textArea) {
        this.display = textArea;
    }

    public void SetErrors(TextArea textArea) {
        this.errors = textArea;
    }

    public void SetLoader(Loader loader) {
        this.loader = loader;
    }

    public int CheckArgs(LispObject lispObject, String string, int n, int n2) throws LispException {
        if (!Primitive.Consp(lispObject) && lispObject != NIL) {
            throw new LispException(string + ": improper argument list:", lispObject);
        }
        LispObject lispObject2 = lispObject;
        int n3 = 0;
        while (Primitive.Consp(lispObject2)) {
            ++n3;
            lispObject2 = Primitive.Cdr(lispObject2);
        }
        if (lispObject2 != NIL) {
            throw new LispException(string + ": dotted pair in" + "argument list:", lispObject);
        }
        if (n == n2 & n3 != n2) {
            throw new LispException(string + ": requires exactly " + n + " argument" + (n == 1 ? ":" : "s:"), lispObject);
        }
        if (n + 1 == n2 && (n3 < n || n3 > n2)) {
            throw new LispException(string + ": requires either " + n + " or " + n2 + "arguments:", lispObject);
        }
        if (n3 < n) {
            throw new LispException(string + ": not enough arguments " + "(at least " + n + " required):", lispObject);
        }
        if (n3 > n2 && n2 != -1) {
            throw new LispException(string + ": too many arguments " + "(no more than " + n2 + " allowed):", lispObject);
        }
        return n3;
    }

    public int CheckList(LispObject lispObject, String string) throws LispException {
        int n = 0;
        if (lispObject != NIL && !Primitive.Consp(lispObject)) {
            throw new LispException(string + ": argument is not a list:", lispObject);
        }
        LispObject lispObject2 = lispObject;
        while (Primitive.Consp(lispObject2)) {
            ++n;
            lispObject2 = Primitive.Cdr(lispObject2);
        }
        if (lispObject2 != NIL) {
            throw new LispException(string + ": dotted pair in " + "argument:", lispObject);
        }
        return n;
    }

    public int CheckMapArgs(LispObject lispObject, String string, LispObjectWrapper lispObjectWrapper, LispObjectWrapper lispObjectWrapper2, LispObjectWrapper lispObjectWrapper3) throws LispException {
        if (!Primitive.Consp(lispObject) && lispObject != NIL) {
            throw new LispException(string + ": argument is not a list:", lispObject);
        }
        LispObject lispObject2 = lispObject;
        int n = 0;
        while (Primitive.Consp(lispObject2)) {
            ++n;
            lispObject2 = Primitive.Cdr(lispObject2);
        }
        int n2 = n - 1;
        if (lispObject2 != NIL) {
            throw new LispException(string + ": dotted pair in argument" + " list:", lispObject);
        }
        if (n < 2) {
            throw new LispException(string + ": requires at least two args" + " (plus optional keywords):", lispObject);
        }
        lispObjectWrapper2.object = Primitive.Car(lispObject);
        lispObject = Primitive.Cdr(lispObject);
        lispObjectWrapper3.object = NIL;
        Primitive.Preserve(lispObjectWrapper3.object);
        while (Primitive.Cddr(lispObject) != NIL) {
            if (!Primitive.Listp(Primitive.Car(lispObject))) {
                throw new LispException(string + ": arguments should be lists", lispObject);
            }
            lispObjectWrapper3.object = Primitive.MakeCons(Primitive.Car(lispObject), lispObjectWrapper3.object);
            Primitive.Release();
            Primitive.Preserve(lispObjectWrapper3.object);
            lispObject = Primitive.Cdr(lispObject);
        }
        Primitive.Release();
        lispObjectWrapper.object = Primitive.MakeSymbol("EQL").GetFunction();
        if (Primitive.Car(lispObject) == TEST) {
            n2 -= 2;
            lispObjectWrapper.object = Primitive.Cadr(lispObject);
        } else {
            Primitive.Preserve(lispObjectWrapper3.object);
            while (lispObject != NIL) {
                if (!Primitive.Listp(Primitive.Car(lispObject))) {
                    throw new LispException(string + ": arguments should be lists", lispObject);
                }
                lispObjectWrapper3.object = Primitive.MakeCons(Primitive.Car(lispObject), lispObjectWrapper3.object);
                Primitive.Release();
                Primitive.Preserve(lispObjectWrapper3.object);
                lispObject = Primitive.Cdr(lispObject);
            }
            Primitive.Release();
        }
        lispObjectWrapper3.object = Primitive.Reverse(lispObjectWrapper3.object);
        return n2;
    }

    private void AddPrimitive(String string, Callable callable, boolean bl) {
        Symbol symbol = Primitive.MakeSymbol(string);
        Primitive.Preserve(symbol);
        symbol.SetFunction(Primitive.MakeBuiltin(string, callable, bl));
    }

    private void AddPrimitive(String string, Callable callable) {
        this.AddPrimitive(string, callable, false);
    }

    public Primitive(Evaluater evaluater) {
        this.evaluater = evaluater;
        this.AddPrimitive("LOAD", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "LOAD", 1, 1);
                if (!Lisp51ToolKit.LispStringp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("LOAD: Argument must be a string:", Lisp51ToolKit.Car(lispObject));
                }
                return Primitive.this.loader.Load(Lisp51ToolKit.Car(lispObject).toString());
            }
        });
        this.AddPrimitive("PRINT", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "PRINT", 1, 1);
                String string = Lisp51ToolKit.Car(lispObject).toString();
                Primitive.this.display.append(string);
                return Lisp51ToolKit.Car(lispObject);
            }
        });
        this.AddPrimitive("ERROR", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "ERROR", 1, -1);
                int n = Primitive.Length(lispObject);
                String string = "";
                for (int i = 0; i < n; ++i) {
                    string = string + Primitive.Nth(i, lispObject).toString();
                }
                Primitive.this.errors.append(string + "\n");
                return Lisp51ToolKit.NIL;
            }
        });
        this.AddPrimitive("GC", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "GC", 0, 0);
                long l = Lisp51ToolKit.GC();
                Primitive.this.display.append("GC'd " + l + " objects\n");
                return Lisp51ToolKit.NIL;
            }
        });
        this.AddPrimitive("SET-GC-LIMIT", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "SET-GC-LIMIT", 1, 1);
                if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("SET-GC-LIMIT: argument must be numeric", Lisp51ToolKit.Car(lispObject));
                }
                Lisp51ToolKit.SetGCLimit((int)Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject)).GetValue());
                return Lisp51ToolKit.Car(lispObject);
            }
        });
        this.AddPrimitive("QUOTE", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "QUOTE", 1, 1);
                return Primitive.CopyList(Lisp51ToolKit.Car(lispObject));
            }
        }, true);
        this.AddPrimitive("BACKQUOTE", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                LispObject lispObject2;
                Primitive.this.CheckArgs(lispObject, "BACKQUOTE", 1, 1);
                LispObject lispObject3 = Lisp51ToolKit.Car(lispObject);
                LispObject lispObject4 = lispObject2 = Lisp51ToolKit.NIL;
                if (!Lisp51ToolKit.Consp(lispObject3)) {
                    return lispObject3;
                }
                if (Lisp51ToolKit.Car(lispObject3) == Lisp51ToolKit.COMMA) {
                    Primitive.this.CheckArgs(Lisp51ToolKit.Cdr(lispObject3), "COMMA", 1, 1);
                    return Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Cadr(lispObject3));
                }
                if (Lisp51ToolKit.Car(lispObject3) == Lisp51ToolKit.COMMA_AT) {
                    throw new LispException("BACKQUOTE: BACKQUOTE may not be followed immediately by COMMA-AT", lispObject);
                }
                while (Lisp51ToolKit.Consp(lispObject3)) {
                    LispObject lispObject5;
                    if (Lisp51ToolKit.Consp(Lisp51ToolKit.Car(lispObject3)) && Lisp51ToolKit.Caar(lispObject3) == Lisp51ToolKit.COMMA) {
                        Primitive.this.CheckArgs(Lisp51ToolKit.Cdar(lispObject3), "COMMA", 1, 1);
                        lispObject5 = Lisp51ToolKit.MakeCons(Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Cadar(lispObject3)), Lisp51ToolKit.NIL);
                        if (lispObject4 == Lisp51ToolKit.NIL) {
                            lispObject4 = lispObject2 = lispObject5;
                            Lisp51ToolKit.Preserve(lispObject4);
                        } else {
                            Lisp51ToolKit.Rplacd(lispObject2, lispObject5);
                            lispObject2 = Lisp51ToolKit.Cdr(lispObject2);
                        }
                    } else if (Lisp51ToolKit.Consp(Lisp51ToolKit.Car(lispObject3)) && Lisp51ToolKit.Caar(lispObject3) == Lisp51ToolKit.COMMA_AT) {
                        Primitive.this.CheckArgs(Lisp51ToolKit.Cdar(lispObject3), "COMMA-AT", 1, 1);
                        lispObject5 = Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Cadar(lispObject3));
                        if (lispObject4 == Lisp51ToolKit.NIL) {
                            if (lispObject5 != Lisp51ToolKit.NIL) {
                                if (Lisp51ToolKit.Consp(lispObject5)) {
                                    lispObject4 = lispObject5;
                                    lispObject2 = Primitive.Last(lispObject4);
                                    Lisp51ToolKit.Preserve(lispObject4);
                                } else {
                                    lispObject4 = lispObject2 = lispObject5;
                                    Lisp51ToolKit.Preserve(lispObject4);
                                }
                            }
                        } else if (lispObject5 != Lisp51ToolKit.NIL) {
                            if (Lisp51ToolKit.Consp(lispObject5)) {
                                Lisp51ToolKit.Rplacd(lispObject2, lispObject5);
                                lispObject2 = Primitive.Last(lispObject2);
                            } else {
                                Lisp51ToolKit.Rplacd(lispObject2, lispObject5);
                            }
                        }
                    } else if (Lisp51ToolKit.Consp(Lisp51ToolKit.Car(lispObject3))) {
                        lispObject5 = Lisp51ToolKit.MakeCons(Lisp51ToolKit.BACKQUOTE, Lisp51ToolKit.NIL);
                        Lisp51ToolKit.Preserve(lispObject5);
                        Lisp51ToolKit.Rplacd(lispObject5, Lisp51ToolKit.MakeCons(Lisp51ToolKit.Car(lispObject3), Lisp51ToolKit.NIL));
                        LispObject lispObject6 = Primitive.this.evaluater.EvalSexpr(lispObject5);
                        Lisp51ToolKit.Release();
                        if (lispObject4 == Lisp51ToolKit.NIL) {
                            lispObject4 = lispObject2 = Lisp51ToolKit.MakeCons(lispObject6, Lisp51ToolKit.NIL);
                            Lisp51ToolKit.Preserve(lispObject4);
                        } else {
                            Lisp51ToolKit.Rplacd(lispObject2, Lisp51ToolKit.MakeCons(lispObject6, Lisp51ToolKit.NIL));
                            lispObject2 = Lisp51ToolKit.Cdr(lispObject2);
                        }
                    } else if (lispObject4 == Lisp51ToolKit.NIL) {
                        lispObject4 = lispObject2 = Lisp51ToolKit.MakeCons(Lisp51ToolKit.Car(lispObject3), Lisp51ToolKit.NIL);
                        Lisp51ToolKit.Preserve(lispObject4);
                    } else {
                        Lisp51ToolKit.Rplacd(lispObject2, Lisp51ToolKit.MakeCons(Lisp51ToolKit.Car(lispObject3), Lisp51ToolKit.NIL));
                        lispObject2 = Lisp51ToolKit.Cdr(lispObject2);
                    }
                    lispObject3 = Lisp51ToolKit.Cdr(lispObject3);
                }
                if (lispObject4 != Lisp51ToolKit.NIL) {
                    Lisp51ToolKit.Release();
                }
                if (Lisp51ToolKit.Consp(lispObject4)) {
                    Lisp51ToolKit.Rplacd(lispObject2, lispObject3);
                }
                return lispObject4;
            }
        }, true);
        this.AddPrimitive("COMMA", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                throw new LispException("COMMA: no enclosing BACKQUOTE found: ", lispObject);
            }
        });
        this.AddPrimitive("COMMA-AT", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                throw new LispException("COMMA-AT: no enclosing BACKQUOTE found: ", lispObject);
            }
        });
        this.AddPrimitive("MACROEXPAND-1", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "MACROEXPAND-1", 1, 1);
                return Primitive.this.evaluater.MacroExpand1(Lisp51ToolKit.Car(lispObject));
            }
        });
        this.AddPrimitive("FUNCTION", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "FUNCTION", 1, 1);
                LispObject lispObject2 = Lisp51ToolKit.Car(lispObject);
                if (Lisp51ToolKit.Symbolp(lispObject2)) {
                    if ((lispObject2 = Lisp51ToolKit.CvtToSymbol(lispObject2).GetFunction()) == null) {
                        throw new LispException("FUNCTION: no function binding: " + Lisp51ToolKit.Car(lispObject));
                    }
                    if (Lisp51ToolKit.Builtinp(lispObject2) && !Lisp51ToolKit.CvtToBuiltin(lispObject2).GetSpecial()) {
                        return lispObject2;
                    }
                    if (Lisp51ToolKit.Consp(lispObject2) && Lisp51ToolKit.Car(lispObject2) == Lisp51ToolKit.LAMBDA_CLOSURE) {
                        return lispObject2;
                    }
                    throw new LispException("FUNCTION: symbol must be bound to a builtin or lambda-closure: " + Lisp51ToolKit.Car(lispObject));
                }
                if (Lisp51ToolKit.Builtinp(lispObject2)) {
                    if (Lisp51ToolKit.CvtToBuiltin(lispObject2).GetSpecial()) {
                        throw new LispException("FUNCTION: can't use FUNCTION on special functions: " + Lisp51ToolKit.Car(lispObject));
                    }
                    return lispObject2;
                }
                if (Lisp51ToolKit.Consp(lispObject2)) {
                    if (Lisp51ToolKit.Car(lispObject2) == Lisp51ToolKit.LAMBDA_CLOSURE) {
                        return lispObject2;
                    }
                    if (Lisp51ToolKit.Car(lispObject2) == Lisp51ToolKit.LAMBDA) {
                        return Lisp51ToolKit.MakeCons(Lisp51ToolKit.LAMBDA_CLOSURE, Lisp51ToolKit.MakeCons(Lisp51ToolKit.environment, Lisp51ToolKit.Cdr(lispObject2)));
                    }
                    throw new LispException("FUNCTION: not a function: " + Lisp51ToolKit.Car(lispObject));
                }
                throw new LispException("FUNCTION: not a function: " + Lisp51ToolKit.Car(lispObject));
            }
        }, true);
        this.AddPrimitive("DEFMACRO", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "DEFMACRO", 2, -1);
                if (!Lisp51ToolKit.Symbolp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("DEFMACRO: first argument must be a symbol: " + Lisp51ToolKit.Car(lispObject));
                }
                Primitive.this.CheckList(Lisp51ToolKit.Cadr(lispObject), "DEFMACRO");
                Cons cons = Lisp51ToolKit.MakeCons(Lisp51ToolKit.MACRO, Lisp51ToolKit.Cdr(lispObject));
                Lisp51ToolKit.CvtToSymbol(Lisp51ToolKit.Car(lispObject)).SetFunction(cons);
                return Lisp51ToolKit.Car(lispObject);
            }
        }, true);
        this.AddPrimitive("DEFUN", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "DEFUN", 2, -1);
                if (!Lisp51ToolKit.Symbolp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("DEFUN: first argument must be a symbol: " + Lisp51ToolKit.Car(lispObject));
                }
                Primitive.this.CheckList(Lisp51ToolKit.Cadr(lispObject), "DEFUN");
                Cons cons = Lisp51ToolKit.MakeCons(Lisp51ToolKit.LAMBDA_CLOSURE, Lisp51ToolKit.MakeCons(Lisp51ToolKit.environment, Lisp51ToolKit.Cdr(lispObject)));
                Lisp51ToolKit.CvtToSymbol(Lisp51ToolKit.Car(lispObject)).SetFunction(cons);
                return Lisp51ToolKit.Car(lispObject);
            }
        }, true);
        this.AddPrimitive("SET", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "SET", 2, 2);
                if (!Lisp51ToolKit.Symbolp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("SET: first argument must evaluate to a symbol: ", Lisp51ToolKit.Car(lispObject));
                }
                LispObject lispObject2 = Primitive.this.evaluater.BindingReference(Lisp51ToolKit.CvtToSymbol(Lisp51ToolKit.Car(lispObject)));
                if (Lisp51ToolKit.Consp(lispObject2)) {
                    Lisp51ToolKit.Rplacd(lispObject2, Lisp51ToolKit.Cadr(lispObject));
                } else {
                    Lisp51ToolKit.CvtToSymbol(lispObject2).SetValue(Lisp51ToolKit.Cadr(lispObject));
                }
                return Lisp51ToolKit.Cadr(lispObject);
            }
        });
        this.AddPrimitive("SETQ", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "SETQ", 2, 2);
                if (!Lisp51ToolKit.Symbolp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("SETQ: first argument must be a symbol: ", Lisp51ToolKit.Car(lispObject));
                }
                LispObject lispObject2 = Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Cadr(lispObject));
                LispObject lispObject3 = Primitive.this.evaluater.BindingReference(Lisp51ToolKit.CvtToSymbol(Lisp51ToolKit.Car(lispObject)));
                if (Lisp51ToolKit.Consp(lispObject3)) {
                    Lisp51ToolKit.Rplacd(lispObject3, lispObject2);
                } else {
                    Lisp51ToolKit.CvtToSymbol(lispObject3).SetValue(lispObject2);
                }
                return lispObject2;
            }
        }, true);
        this.AddPrimitive("GET", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "GET", 2, 2);
                if (!Lisp51ToolKit.Symbolp(Lisp51ToolKit.Car(lispObject)) || !Lisp51ToolKit.Symbolp(Lisp51ToolKit.Cadr(lispObject))) {
                    throw new LispException("GET: both arguments must be symbols: ", lispObject);
                }
                LispObject lispObject2 = Lisp51ToolKit.CvtToSymbol(Lisp51ToolKit.Car(lispObject)).GetPlist();
                while (Lisp51ToolKit.Consp(lispObject2)) {
                    LispObject lispObject3 = Lisp51ToolKit.Car(lispObject2);
                    if (!Lisp51ToolKit.Consp(lispObject3) || Primitive.Length(lispObject3) != 2) {
                        throw new LispException("GET: malformed property list: ", lispObject2);
                    }
                    if (Lisp51ToolKit.Cadr(lispObject) == Lisp51ToolKit.Car(lispObject3)) {
                        return Lisp51ToolKit.Cadr(lispObject3);
                    }
                    lispObject2 = Lisp51ToolKit.Cdr(lispObject2);
                }
                return Lisp51ToolKit.NIL;
            }
        });
        this.AddPrimitive("PUT", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                LispObject lispObject2;
                Primitive.this.CheckArgs(lispObject, "PUT", 3, 3);
                if (!Lisp51ToolKit.Symbolp(Lisp51ToolKit.Car(lispObject)) || !Lisp51ToolKit.Symbolp(Lisp51ToolKit.Cadr(lispObject))) {
                    throw new LispException("PUT: first two arguments must be symbols: ", lispObject);
                }
                LispObject lispObject3 = Lisp51ToolKit.CvtToSymbol(Lisp51ToolKit.Car(lispObject)).GetPlist();
                while (Lisp51ToolKit.Consp(lispObject3)) {
                    lispObject2 = Lisp51ToolKit.Car(lispObject3);
                    if (!Lisp51ToolKit.Consp(lispObject2) || Primitive.Length(lispObject2) != 2) {
                        throw new LispException("PUT: malformed property list: ", lispObject3);
                    }
                    if (Lisp51ToolKit.Cadr(lispObject) == Lisp51ToolKit.Car(lispObject2)) {
                        Lisp51ToolKit.Rplaca(Lisp51ToolKit.Cdr(lispObject2), Lisp51ToolKit.Caddr(lispObject));
                        return Lisp51ToolKit.Caddr(lispObject);
                    }
                    lispObject3 = Lisp51ToolKit.Cdr(lispObject3);
                }
                lispObject3 = Lisp51ToolKit.CvtToSymbol(Lisp51ToolKit.Car(lispObject)).GetPlist();
                lispObject2 = Lisp51ToolKit.MakeCons(Lisp51ToolKit.Cadr(lispObject), Lisp51ToolKit.MakeCons(Lisp51ToolKit.Caddr(lispObject), Lisp51ToolKit.NIL));
                Lisp51ToolKit.CvtToSymbol(Lisp51ToolKit.Car(lispObject)).SetPlist(Lisp51ToolKit.MakeCons(lispObject2, lispObject3));
                return Lisp51ToolKit.Caddr(lispObject);
            }
        });
        this.AddPrimitive("SYMBOL-FUNCTION", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "SYMBOL-FUNCTION", 1, 1);
                if (!Lisp51ToolKit.Symbolp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("SYMBOL-FUNCTION: argument must be a symbol " + Lisp51ToolKit.Car(lispObject));
                }
                return Lisp51ToolKit.CvtToSymbol(Lisp51ToolKit.Car(lispObject)).GetFunction();
            }
        });
        this.AddPrimitive("SYMBOL-FUNCTION-SET", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "SYMBOL-FUNCTION-SET", 2, 2);
                if (!Lisp51ToolKit.Symbolp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("SYMBOL-FUNCTION-SET: 1st argument must be a symbol " + Lisp51ToolKit.Car(lispObject));
                }
                Lisp51ToolKit.CvtToSymbol(Lisp51ToolKit.Car(lispObject)).SetFunction(Lisp51ToolKit.Cadr(lispObject));
                return Lisp51ToolKit.Cadr(lispObject);
            }
        });
        this.AddPrimitive("SYMBOL-PLIST", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "SYMBOL-PLIST", 1, 1);
                if (!Lisp51ToolKit.Symbolp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("SYMBOL-PLIST: argument must be a symbol " + Lisp51ToolKit.Car(lispObject));
                }
                return Lisp51ToolKit.CvtToSymbol(Lisp51ToolKit.Car(lispObject)).GetPlist();
            }
        });
        this.AddPrimitive("SYMBOL-PLIST-SET", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "SYMBOL-PLIST-SET", 2, 2);
                if (!Lisp51ToolKit.Symbolp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("SYMBOL-FUNCTION-SET: 1st argument must be a symbol " + Lisp51ToolKit.Car(lispObject));
                }
                Lisp51ToolKit.CvtToSymbol(Lisp51ToolKit.Car(lispObject)).SetPlist(Lisp51ToolKit.Cadr(lispObject));
                return Lisp51ToolKit.Cadr(lispObject);
            }
        });
        this.AddPrimitive("COND", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "COND", 0, -1);
                LispObject lispObject2 = lispObject;
                while (Lisp51ToolKit.Consp(lispObject2)) {
                    if (!Lisp51ToolKit.Consp(Lisp51ToolKit.Car(lispObject2))) {
                        throw new LispException("COND: argument is not a list: " + Lisp51ToolKit.Car(lispObject2));
                    }
                    lispObject2 = Lisp51ToolKit.Cdr(lispObject2);
                }
                LispObject lispObject3 = Lisp51ToolKit.NIL;
                while (Lisp51ToolKit.Consp(lispObject) && (lispObject3 = Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Caar(lispObject))) == Lisp51ToolKit.NIL) {
                    lispObject = Lisp51ToolKit.Cdr(lispObject);
                }
                if (lispObject3 == Lisp51ToolKit.NIL) {
                    return Lisp51ToolKit.NIL;
                }
                LispObject lispObject4 = Lisp51ToolKit.Cdar(lispObject);
                while (Lisp51ToolKit.Consp(lispObject4)) {
                    lispObject3 = Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Car(lispObject4));
                    lispObject4 = Lisp51ToolKit.Cdr(lispObject4);
                }
                if (lispObject4 != Lisp51ToolKit.NIL) {
                    throw new LispException("COND: clause is dotted: " + Lisp51ToolKit.Car(lispObject));
                }
                return lispObject3;
            }
        }, true);
        this.AddPrimitive("IF", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                int n = Primitive.this.CheckArgs(lispObject, "IF", 2, 3);
                if (Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Car(lispObject)) == Lisp51ToolKit.NIL) {
                    if (n == 2) {
                        return Lisp51ToolKit.NIL;
                    }
                    return Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Caddr(lispObject));
                }
                return Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Cadr(lispObject));
            }
        }, true);
        this.AddPrimitive("EVAL", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "EVAL", 1, 1);
                return Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Car(lispObject));
            }
        });
        this.AddPrimitive("FUNCALL", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "FUNCALL", 1, -1);
                LispObject lispObject2 = Lisp51ToolKit.Car(lispObject);
                if (Lisp51ToolKit.Builtinp(lispObject2) && Lisp51ToolKit.CvtToBuiltin(lispObject2).GetSpecial()) {
                    throw new LispException("FUNCALL: can't funcall a special primitive: " + lispObject2);
                }
                return Primitive.this.evaluater.Apply(lispObject2, Lisp51ToolKit.Cdr(lispObject));
            }
        });
        this.AddPrimitive("APPLY", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "APPLY", 2, 2);
                return Primitive.this.evaluater.Apply(Lisp51ToolKit.Car(lispObject), Lisp51ToolKit.Cadr(lispObject));
            }
        });
        this.AddPrimitive("LET", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "LET", 1, -1);
                LispObject lispObject2 = Lisp51ToolKit.Car(lispObject);
                LispObject lispObject3 = Lisp51ToolKit.environment;
                LispObject lispObject4 = Lisp51ToolKit.environment;
                Lisp51ToolKit.Preserve(lispObject4);
                if (!Lisp51ToolKit.Consp(lispObject2)) {
                    throw new LispException("LET: first argument must be a list of bindings: " + Lisp51ToolKit.Car(lispObject));
                }
                do {
                    if (!Lisp51ToolKit.Consp(Lisp51ToolKit.Car(lispObject2))) {
                        throw new LispException("LET: binding is not a list: " + Lisp51ToolKit.Car(lispObject2));
                    }
                    if (!Lisp51ToolKit.Consp(Lisp51ToolKit.Cdar(lispObject2)) || Lisp51ToolKit.Cddar(lispObject2) != Lisp51ToolKit.NIL) {
                        throw new LispException("LET: malformed binding list: " + Lisp51ToolKit.Car(lispObject2));
                    }
                    lispObject4 = Lisp51ToolKit.MakeCons(Lisp51ToolKit.MakeCons(Lisp51ToolKit.Caar(lispObject2), Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Cadar(lispObject2))), lispObject4);
                    Lisp51ToolKit.Release();
                    Lisp51ToolKit.Preserve(lispObject4);
                } while (Lisp51ToolKit.Consp(lispObject2 = Lisp51ToolKit.Cdr(lispObject2)));
                if (lispObject2 != Lisp51ToolKit.NIL) {
                    throw new LispException("LET: list of bindings is dotted : " + Lisp51ToolKit.Car(lispObject));
                }
                Lisp51ToolKit.Release();
                Lisp51ToolKit.environment = lispObject4;
                LispObject lispObject5 = Primitive.this.evaluater.Progn(Lisp51ToolKit.Cdr(lispObject));
                Lisp51ToolKit.environment = lispObject3;
                return lispObject5;
            }
        }, true);
        this.AddPrimitive("LET*", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "LET*", 1, -1);
                LispObject lispObject2 = Lisp51ToolKit.Car(lispObject);
                LispObject lispObject3 = Lisp51ToolKit.environment;
                if (!Lisp51ToolKit.Consp(lispObject2)) {
                    throw new LispException("LET*: binding is not a list: " + lispObject2);
                }
                do {
                    if (!Lisp51ToolKit.Consp(Lisp51ToolKit.Car(lispObject2))) {
                        throw new LispException("LET*: binding is not a list: " + Lisp51ToolKit.Car(lispObject2));
                    }
                    if (!Lisp51ToolKit.Consp(Lisp51ToolKit.Cdar(lispObject2)) || Lisp51ToolKit.Cddar(lispObject2) != Lisp51ToolKit.NIL) {
                        throw new LispException("LET*: malformed binding list: " + Lisp51ToolKit.Car(lispObject2));
                    }
                    Lisp51ToolKit.environment = Lisp51ToolKit.MakeCons(Lisp51ToolKit.MakeCons(Lisp51ToolKit.Caar(lispObject2), Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Cadar(lispObject2))), Lisp51ToolKit.environment);
                } while (Lisp51ToolKit.Consp(lispObject2 = Lisp51ToolKit.Cdr(lispObject2)));
                if (lispObject2 != Lisp51ToolKit.NIL) {
                    throw new LispException("LET*: list of bindings is dotted: " + Lisp51ToolKit.Car(lispObject));
                }
                LispObject lispObject4 = Primitive.this.evaluater.Progn(Lisp51ToolKit.Cdr(lispObject));
                Lisp51ToolKit.environment = lispObject3;
                return lispObject4;
            }
        }, true);
        this.AddPrimitive("DO", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                LispObject lispObject2;
                Primitive.this.CheckArgs(lispObject, "DO", 2, -1);
                LispObject lispObject3 = Lisp51ToolKit.Car(lispObject);
                LispObject lispObject4 = Lisp51ToolKit.Cadr(lispObject);
                LispObject lispObject5 = Lisp51ToolKit.environment;
                LispObject lispObject6 = Lisp51ToolKit.environment;
                Lisp51ToolKit.Preserve(lispObject6);
                if (!Lisp51ToolKit.Listp(lispObject3)) {
                    throw new LispException("DO: first argument must be a list of variable bindings and update expressions: " + Lisp51ToolKit.Car(lispObject));
                }
                do {
                    if (!Lisp51ToolKit.Listp(Lisp51ToolKit.Car(lispObject3))) {
                        throw new LispException("DO: binding is not a list: " + Lisp51ToolKit.Car(lispObject3));
                    }
                    lispObject2 = Lisp51ToolKit.Car(lispObject3);
                    if (lispObject2 != Lisp51ToolKit.NIL && Primitive.Length(lispObject2) != 2 && Primitive.Length(lispObject2) != 3 && !Lisp51ToolKit.Symbolp(Lisp51ToolKit.Car(lispObject2))) {
                        throw new LispException("DO: malformed binding list: " + Lisp51ToolKit.Car(lispObject3));
                    }
                    if (lispObject2 == Lisp51ToolKit.NIL) continue;
                    lispObject6 = Lisp51ToolKit.MakeCons(Lisp51ToolKit.MakeCons(Lisp51ToolKit.Car(lispObject2), Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Cadr(lispObject2))), lispObject6);
                    Lisp51ToolKit.Release();
                    Lisp51ToolKit.Preserve(lispObject6);
                } while (Lisp51ToolKit.Consp(lispObject3 = Lisp51ToolKit.Cdr(lispObject3)));
                if (!Lisp51ToolKit.Consp(lispObject4)) {
                    throw new LispException("DO: exit clause is not a list: " + lispObject4);
                }
                Lisp51ToolKit.Release();
                Lisp51ToolKit.environment = lispObject6;
                while (Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Car(lispObject4)) == Lisp51ToolKit.NIL) {
                    Primitive.this.evaluater.Progn(Lisp51ToolKit.Cddr(lispObject));
                    lispObject3 = Lisp51ToolKit.Car(lispObject);
                    lispObject6 = lispObject5;
                    Lisp51ToolKit.Preserve(lispObject6);
                    do {
                        if ((lispObject2 = Lisp51ToolKit.Car(lispObject3)) == Lisp51ToolKit.NIL) continue;
                        lispObject6 = Lisp51ToolKit.MakeCons(Lisp51ToolKit.MakeCons(Lisp51ToolKit.Car(lispObject2), Primitive.Length(lispObject2) == 2 ? Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Car(lispObject2)) : Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Caddr(lispObject2))), lispObject6);
                        Lisp51ToolKit.Release();
                        Lisp51ToolKit.Preserve(lispObject6);
                    } while (Lisp51ToolKit.Consp(lispObject3 = Lisp51ToolKit.Cdr(lispObject3)));
                    Lisp51ToolKit.Release();
                    Lisp51ToolKit.environment = lispObject6;
                }
                lispObject2 = Primitive.this.evaluater.Progn(Lisp51ToolKit.Cdr(lispObject4));
                Lisp51ToolKit.environment = lispObject5;
                return lispObject2;
            }
        }, true);
        this.AddPrimitive("DO*", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                LispObject lispObject2;
                Primitive.this.CheckArgs(lispObject, "DO*", 2, -1);
                LispObject lispObject3 = Lisp51ToolKit.Car(lispObject);
                LispObject lispObject4 = Lisp51ToolKit.Cadr(lispObject);
                LispObject lispObject5 = Lisp51ToolKit.environment;
                if (!Lisp51ToolKit.Listp(lispObject3)) {
                    throw new LispException("DO: first argument must be a list of variable bindings and update expressions: " + Lisp51ToolKit.Car(lispObject));
                }
                do {
                    if (!Lisp51ToolKit.Listp(Lisp51ToolKit.Car(lispObject3))) {
                        throw new LispException("DO: binding is not a list: " + Lisp51ToolKit.Car(lispObject3));
                    }
                    lispObject2 = Lisp51ToolKit.Car(lispObject3);
                    if (lispObject2 != Lisp51ToolKit.NIL && Primitive.Length(lispObject2) != 2 && Primitive.Length(lispObject2) != 3 && !Lisp51ToolKit.Symbolp(Lisp51ToolKit.Car(lispObject2))) {
                        throw new LispException("DO: malformed binding list: " + Lisp51ToolKit.Car(lispObject3));
                    }
                    if (lispObject2 == Lisp51ToolKit.NIL) continue;
                    Lisp51ToolKit.environment = Lisp51ToolKit.MakeCons(Lisp51ToolKit.MakeCons(Lisp51ToolKit.Car(lispObject2), Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Cadr(lispObject2))), Lisp51ToolKit.environment);
                } while (Lisp51ToolKit.Consp(lispObject3 = Lisp51ToolKit.Cdr(lispObject3)));
                if (!Lisp51ToolKit.Consp(lispObject4)) {
                    throw new LispException("DO: exit clause is not a list: " + lispObject4);
                }
                while (Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Car(lispObject4)) == Lisp51ToolKit.NIL) {
                    Primitive.this.evaluater.Progn(Lisp51ToolKit.Cddr(lispObject));
                    lispObject3 = Lisp51ToolKit.Car(lispObject);
                    lispObject2 = Lisp51ToolKit.CvtToBuiltin(Lisp51ToolKit.MakeSymbol("SETQ").GetFunction());
                    Lisp51ToolKit.Preserve(lispObject2);
                    do {
                        LispObject lispObject6;
                        if ((lispObject6 = Lisp51ToolKit.Car(lispObject3)) == Lisp51ToolKit.NIL) continue;
                        Cons cons = Lisp51ToolKit.MakeCons(Lisp51ToolKit.Car(lispObject6), Lisp51ToolKit.MakeCons(Primitive.Length(lispObject6) == 2 ? Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Car(lispObject6)) : Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Caddr(lispObject6)), Lisp51ToolKit.NIL));
                        Lisp51ToolKit.Preserve(cons);
                        ((Builtin)lispObject2).Call(cons);
                        Lisp51ToolKit.Release();
                    } while (Lisp51ToolKit.Consp(lispObject3 = Lisp51ToolKit.Cdr(lispObject3)));
                    Lisp51ToolKit.Release();
                }
                lispObject2 = Primitive.this.evaluater.Progn(Lisp51ToolKit.Cdr(lispObject4));
                Lisp51ToolKit.environment = lispObject5;
                return lispObject2;
            }
        }, true);
        this.AddPrimitive("PROGN", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                return Primitive.this.evaluater.Progn(lispObject);
            }
        }, true);
        this.AddPrimitive("MAPCAR", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                LispObjectWrapper lispObjectWrapper = new LispObjectWrapper();
                LispObjectWrapper lispObjectWrapper2 = new LispObjectWrapper();
                LispObjectWrapper lispObjectWrapper3 = new LispObjectWrapper();
                int n = Primitive.this.CheckMapArgs(lispObject, "MAPCAR", lispObjectWrapper, lispObjectWrapper2, lispObjectWrapper3);
                LispObject lispObject2 = lispObjectWrapper2.object;
                LispObject lispObject3 = lispObjectWrapper3.object;
                LispObject lispObject4 = Lisp51ToolKit.NIL;
                Lisp51ToolKit.Preserve(lispObject3);
                Lisp51ToolKit.Preserve(lispObject4);
                block0: while (true) {
                    LispObject lispObject5 = Lisp51ToolKit.NIL;
                    LispObject lispObject6 = Lisp51ToolKit.NIL;
                    Lisp51ToolKit.Preserve(lispObject5);
                    Lisp51ToolKit.Preserve(lispObject6);
                    for (int i = 0; i < n; ++i) {
                        Lisp51ToolKit.Release();
                        Lisp51ToolKit.Release();
                        LispObject lispObject7 = Primitive.Nth(i, lispObject3);
                        if (!Lisp51ToolKit.Consp(lispObject7)) break block0;
                        Lisp51ToolKit.Preserve(lispObject6);
                        lispObject5 = Lisp51ToolKit.MakeCons(Lisp51ToolKit.Car(lispObject7), lispObject5);
                        Lisp51ToolKit.Release();
                        Lisp51ToolKit.Preserve(lispObject5);
                        lispObject6 = Lisp51ToolKit.MakeCons(Lisp51ToolKit.Cdr(lispObject7), lispObject6);
                        Lisp51ToolKit.Preserve(lispObject6);
                    }
                    lispObject3 = Primitive.Reverse(lispObject6);
                    Lisp51ToolKit.Release();
                    Lisp51ToolKit.Preserve(lispObject3);
                    lispObject5 = Primitive.Reverse(lispObject5);
                    lispObject4 = Lisp51ToolKit.MakeCons(Primitive.this.evaluater.Apply(lispObject2, lispObject5), lispObject4);
                    Lisp51ToolKit.Release();
                    Lisp51ToolKit.Release();
                    Lisp51ToolKit.Release();
                    Lisp51ToolKit.Preserve(lispObject4);
                }
                Lisp51ToolKit.Release();
                Lisp51ToolKit.Release();
                return Primitive.Reverse(lispObject4);
            }
        });
        this.AddPrimitive("CONS", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "CONS", 2, 2);
                return Lisp51ToolKit.MakeCons(Lisp51ToolKit.Car(lispObject), Lisp51ToolKit.Cadr(lispObject));
            }
        });
        this.AddPrimitive("CAR", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "CAR", 1, 1);
                if (!Lisp51ToolKit.Listp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("CAR: argument must be a list: " + Lisp51ToolKit.Car(lispObject));
                }
                return Lisp51ToolKit.Caar(lispObject);
            }
        });
        this.AddPrimitive("CDR", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "CDR", 1, 1);
                if (!Lisp51ToolKit.Listp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("CDR: argument must be a list: " + Lisp51ToolKit.Car(lispObject));
                }
                return Lisp51ToolKit.Cdar(lispObject);
            }
        });
        this.AddPrimitive("RPLACA", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "RPLACA", 2, 2);
                if (!Lisp51ToolKit.Consp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("RPLACA: first argument must be a cons: " + Lisp51ToolKit.Car(lispObject));
                }
                Lisp51ToolKit.Rplaca(Lisp51ToolKit.CvtToCons(Lisp51ToolKit.Car(lispObject)), Lisp51ToolKit.Cadr(lispObject));
                return Lisp51ToolKit.Cadr(lispObject);
            }
        });
        this.AddPrimitive("RPLACD", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "RPLACD", 2, 2);
                if (!Lisp51ToolKit.Consp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("RPLACD: first argument must be a cons: " + Lisp51ToolKit.Car(lispObject));
                }
                Lisp51ToolKit.Rplacd(Lisp51ToolKit.CvtToCons(Lisp51ToolKit.Car(lispObject)), Lisp51ToolKit.Cadr(lispObject));
                return Lisp51ToolKit.Cadr(lispObject);
            }
        });
        this.AddPrimitive("MEMBER", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "MEMBER", 2, 4);
                int n = Primitive.Length(lispObject);
                if (n != 2 && n != 4 || n == 3 && Lisp51ToolKit.Caddr(lispObject) != Lisp51ToolKit.TEST) {
                    throw new LispException("MEMBER: Only :TEST is supported: ", lispObject);
                }
                LispObject lispObject2 = Lisp51ToolKit.MakeSymbol("EQL").GetFunction();
                if (n == 4) {
                    lispObject2 = Lisp51ToolKit.Car(Lisp51ToolKit.Cdddr(lispObject));
                }
                if (!Lisp51ToolKit.Listp(Lisp51ToolKit.Cadr(lispObject))) {
                    throw new LispException("MEMBER: second argument must be a list: ", Lisp51ToolKit.Cadr(lispObject));
                }
                LispObject lispObject3 = Lisp51ToolKit.Cadr(lispObject);
                LispObject lispObject4 = Lisp51ToolKit.Car(lispObject);
                LispObject lispObject5 = Lisp51ToolKit.Car(lispObject3);
                while (Lisp51ToolKit.Consp(lispObject3)) {
                    if (Primitive.this.evaluater.Apply(lispObject2, Lisp51ToolKit.MakeCons(lispObject4, Lisp51ToolKit.MakeCons(lispObject5, Lisp51ToolKit.NIL))) != Lisp51ToolKit.NIL) {
                        return lispObject3;
                    }
                    lispObject3 = Lisp51ToolKit.Cdr(lispObject3);
                    lispObject5 = Lisp51ToolKit.Car(lispObject3);
                }
                return Lisp51ToolKit.NIL;
            }
        });
        this.AddPrimitive("LIST", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "LIST", 1, -1);
                return Primitive.CopyList(lispObject);
            }
        });
        this.AddPrimitive("NTH", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "NTH", 2, 2);
                if (!Lisp51ToolKit.Listp(Lisp51ToolKit.Cadr(lispObject))) {
                    throw new LispException("NTH: second argument must be a list: ", Lisp51ToolKit.Cadr(lispObject));
                }
                if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("NTH: first argument must be a number: ", Lisp51ToolKit.Car(lispObject));
                }
                long l = Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject)).GetValue();
                if (l < 0L || l >= (long)Primitive.Length(Lisp51ToolKit.Cadr(lispObject))) {
                    throw new LispException("NTH: index out of bounds: ", Lisp51ToolKit.Car(lispObject));
                }
                return Primitive.Nth(l, Lisp51ToolKit.Cadr(lispObject));
            }
        });
        this.AddPrimitive("NTH-SET", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "NTH-SET", 3, 3);
                if (!Lisp51ToolKit.Listp(Lisp51ToolKit.Cadr(lispObject))) {
                    throw new LispException("NTH-SET: second argument must be a list: ", Lisp51ToolKit.Cadr(lispObject));
                }
                if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("NTH-SET: first argument must be a number: ", Lisp51ToolKit.Car(lispObject));
                }
                long l = Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject)).GetValue();
                if (l < 0L || l >= (long)Primitive.Length(Lisp51ToolKit.Cadr(lispObject))) {
                    throw new LispException("NTH-SET: index out of bounds: ", Lisp51ToolKit.Car(lispObject));
                }
                Lisp51ToolKit.Rplaca(Primitive.NthCdr(l, Lisp51ToolKit.Cadr(lispObject)), Lisp51ToolKit.Caddr(lispObject));
                return Lisp51ToolKit.Caddr(lispObject);
            }
        });
        this.AddPrimitive("NTH-CDR", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "NTH", 2, 2);
                if (!Lisp51ToolKit.Listp(Lisp51ToolKit.Cadr(lispObject))) {
                    throw new LispException("NTH-CDR: second argument must be a list: ", Lisp51ToolKit.Cadr(lispObject));
                }
                if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("NTH-CDR: first argument must be a number: ", Lisp51ToolKit.Car(lispObject));
                }
                long l = Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject)).GetValue();
                if (l < 0L || l >= (long)Primitive.Length(Lisp51ToolKit.Cadr(lispObject))) {
                    throw new LispException("NTH-CDR: index out of bounds: ", Lisp51ToolKit.Car(lispObject));
                }
                return Primitive.NthCdr(l, Lisp51ToolKit.Cadr(lispObject));
            }
        });
        this.AddPrimitive("NTH-CDR-SET", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "NTH-CDR-SET", 3, 3);
                if (!Lisp51ToolKit.Listp(Lisp51ToolKit.Cadr(lispObject))) {
                    throw new LispException("NTH-CDR-SET: second argument must be a list: ", Lisp51ToolKit.Cadr(lispObject));
                }
                if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("NTH-CDR-SET: first argument must be a number: ", Lisp51ToolKit.Car(lispObject));
                }
                long l = Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject)).GetValue();
                if (l < 0L || l >= (long)Primitive.Length(Lisp51ToolKit.Cadr(lispObject))) {
                    throw new LispException("NTH-CDR-SET: index out of bounds: ", Lisp51ToolKit.Car(lispObject));
                }
                Lisp51ToolKit.Rplacd(Primitive.NthCdr(l - 1L, Lisp51ToolKit.Cadr(lispObject)), Lisp51ToolKit.Caddr(lispObject));
                return Lisp51ToolKit.Caddr(lispObject);
            }
        });
        this.AddPrimitive("APPEND", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                LispObject lispObject2 = Lisp51ToolKit.NIL;
                LispObject lispObject3 = Lisp51ToolKit.NIL;
                LispObject lispObject4 = Lisp51ToolKit.NIL;
                LispObject lispObject5 = Lisp51ToolKit.NIL;
                Primitive.this.CheckArgs(lispObject, "APPEND", 0, -1);
                if (lispObject == Lisp51ToolKit.NIL) {
                    return Lisp51ToolKit.NIL;
                }
                lispObject4 = lispObject;
                while (Lisp51ToolKit.Consp(Lisp51ToolKit.Cdr(lispObject4))) {
                    lispObject5 = Lisp51ToolKit.Car(lispObject4);
                    while (Lisp51ToolKit.Consp(lispObject5)) {
                        if (lispObject3 == Lisp51ToolKit.NIL) {
                            lispObject2 = lispObject3 = Lisp51ToolKit.MakeCons(Lisp51ToolKit.Car(lispObject5), Lisp51ToolKit.NIL);
                            Lisp51ToolKit.Preserve(lispObject2);
                        } else {
                            Lisp51ToolKit.CvtToCons(lispObject3).SetCdr(Lisp51ToolKit.MakeCons(Lisp51ToolKit.Car(lispObject5), Lisp51ToolKit.NIL));
                            lispObject3 = Lisp51ToolKit.Cdr(lispObject3);
                        }
                        lispObject5 = Lisp51ToolKit.Cdr(lispObject5);
                    }
                    lispObject4 = Lisp51ToolKit.Cdr(lispObject4);
                }
                if (lispObject3 == Lisp51ToolKit.NIL) {
                    return Lisp51ToolKit.Car(lispObject4);
                }
                Lisp51ToolKit.CvtToCons(lispObject3).SetCdr(Lisp51ToolKit.Car(lispObject4));
                Lisp51ToolKit.Release();
                return lispObject2;
            }
        });
        this.AddPrimitive("COPY-LIST", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "COPY-LIST", 1, 1);
                return Primitive.CopyList(Lisp51ToolKit.Car(lispObject));
            }
        });
        this.AddPrimitive("LENGTH", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "LENGTH", 1, 1);
                int n = Primitive.Length(Lisp51ToolKit.Car(lispObject));
                if (n == -1) {
                    throw new LispException("LENGTH: argument must be a list: ", Lisp51ToolKit.Car(lispObject));
                }
                return Lisp51ToolKit.MakeFixnum(n);
            }
        });
        this.AddPrimitive("=", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "=", 1, -1);
                LispObject lispObject2 = lispObject;
                while (lispObject2 != Lisp51ToolKit.NIL) {
                    if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject2))) {
                        throw new LispException("=: All arguments must be numeric: ", Lisp51ToolKit.Car(lispObject2));
                    }
                    lispObject2 = Lisp51ToolKit.Cdr(lispObject2);
                }
                while (lispObject != Lisp51ToolKit.NIL) {
                    LispObject lispObject3 = Lisp51ToolKit.Car(lispObject);
                    LispObject lispObject4 = Lisp51ToolKit.Cdr(lispObject);
                    while (lispObject4 != Lisp51ToolKit.NIL) {
                        if (Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject4)).GetValue() != Lisp51ToolKit.CvtToFixnum(lispObject3).GetValue()) {
                            return Lisp51ToolKit.NIL;
                        }
                        lispObject4 = Lisp51ToolKit.Cdr(lispObject4);
                    }
                    lispObject = Lisp51ToolKit.Cdr(lispObject);
                }
                return Lisp51ToolKit.T;
            }
        });
        this.AddPrimitive("/=", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "/=", 1, -1);
                LispObject lispObject2 = lispObject;
                while (lispObject2 != Lisp51ToolKit.NIL) {
                    if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject2))) {
                        throw new LispException("/=: All arguments must be numeric: ", Lisp51ToolKit.Car(lispObject2));
                    }
                    lispObject2 = Lisp51ToolKit.Cdr(lispObject2);
                }
                while (lispObject != Lisp51ToolKit.NIL) {
                    LispObject lispObject3 = Lisp51ToolKit.Car(lispObject);
                    LispObject lispObject4 = Lisp51ToolKit.Cdr(lispObject);
                    while (lispObject4 != Lisp51ToolKit.NIL) {
                        if (Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject4)).GetValue() == Lisp51ToolKit.CvtToFixnum(lispObject3).GetValue()) {
                            return Lisp51ToolKit.NIL;
                        }
                        lispObject4 = Lisp51ToolKit.Cdr(lispObject4);
                    }
                    lispObject = Lisp51ToolKit.Cdr(lispObject);
                }
                return Lisp51ToolKit.T;
            }
        });
        this.AddPrimitive(">", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, ">", 2, 2);
                if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject)) || !Lisp51ToolKit.Fixnump(Lisp51ToolKit.Cadr(lispObject))) {
                    throw new LispException(">: All arguments must be numeric: ", lispObject);
                }
                if (Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject)).GetValue() > Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Cadr(lispObject)).GetValue()) {
                    return Lisp51ToolKit.T;
                }
                return Lisp51ToolKit.NIL;
            }
        });
        this.AddPrimitive("<", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "<", 2, 2);
                if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject)) || !Lisp51ToolKit.Fixnump(Lisp51ToolKit.Cadr(lispObject))) {
                    throw new LispException("<: All arguments must be numeric: ", lispObject);
                }
                if (Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject)).GetValue() < Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Cadr(lispObject)).GetValue()) {
                    return Lisp51ToolKit.T;
                }
                return Lisp51ToolKit.NIL;
            }
        });
        this.AddPrimitive("EQ", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "EQ", 2, 2);
                return Lisp51ToolKit.Car(lispObject) == Lisp51ToolKit.Cadr(lispObject) ? Lisp51ToolKit.T : Lisp51ToolKit.NIL;
            }
        });
        this.AddPrimitive("EQL", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "EQL", 2, 2);
                if (Lisp51ToolKit.Car(lispObject) == Lisp51ToolKit.Cadr(lispObject)) {
                    return Lisp51ToolKit.T;
                }
                if (Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject)) && Lisp51ToolKit.Fixnump(Lisp51ToolKit.Cadr(lispObject)) && Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject)).GetValue() == Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Cadr(lispObject)).GetValue()) {
                    return Lisp51ToolKit.T;
                }
                return Lisp51ToolKit.NIL;
            }
        });
        this.AddPrimitive("EQUAL", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "EQUAL", 2, 2);
                return Primitive.Equal(Lisp51ToolKit.Car(lispObject), Lisp51ToolKit.Cadr(lispObject)) ? Lisp51ToolKit.T : Lisp51ToolKit.NIL;
            }
        });
        this.AddPrimitive("ATOM", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "ATOM", 1, 1);
                return Lisp51ToolKit.Symbolp(Lisp51ToolKit.Car(lispObject)) || Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject)) ? Lisp51ToolKit.T : Lisp51ToolKit.NIL;
            }
        });
        this.AddPrimitive("CONSP", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "CONSP", 1, 1);
                return Lisp51ToolKit.Consp(Lisp51ToolKit.Car(lispObject)) ? Lisp51ToolKit.T : Lisp51ToolKit.NIL;
            }
        });
        this.AddPrimitive("FIXNUMP", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "FIXNUMP", 1, 1);
                return Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject)) ? Lisp51ToolKit.T : Lisp51ToolKit.NIL;
            }
        });
        this.AddPrimitive("SYMBOLP", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "SYMBOLP", 1, 1);
                return Lisp51ToolKit.Symbolp(Lisp51ToolKit.Car(lispObject)) ? Lisp51ToolKit.T : Lisp51ToolKit.NIL;
            }
        });
        this.AddPrimitive("BUILTINP", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "BUILTINP", 1, 1);
                return Lisp51ToolKit.Builtinp(Lisp51ToolKit.Car(lispObject)) ? Lisp51ToolKit.T : Lisp51ToolKit.NIL;
            }
        });
        this.AddPrimitive("STRINGP", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "STRINGP", 1, 1);
                return Lisp51ToolKit.LispStringp(Lisp51ToolKit.Car(lispObject)) ? Lisp51ToolKit.T : Lisp51ToolKit.NIL;
            }
        });
        this.AddPrimitive("ARRAYP", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "ARRAYP", 1, 1);
                return Lisp51ToolKit.LispArrayp(Lisp51ToolKit.Car(lispObject)) ? Lisp51ToolKit.T : Lisp51ToolKit.NIL;
            }
        });
        this.AddPrimitive("BOUNDP", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "BOUNDP", 1, 1);
                if (!Lisp51ToolKit.Symbolp(Lisp51ToolKit.Car(lispObject)) || Lisp51ToolKit.CvtToSymbol(Lisp51ToolKit.Car(lispObject)).GetValue() == null) {
                    return Lisp51ToolKit.NIL;
                }
                return Lisp51ToolKit.T;
            }
        });
        this.AddPrimitive("AND", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "AND", 0, -1);
                LispObject lispObject2 = Lisp51ToolKit.T;
                while (Lisp51ToolKit.Consp(lispObject)) {
                    lispObject2 = Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Car(lispObject));
                    if (lispObject2 == Lisp51ToolKit.NIL) {
                        return Lisp51ToolKit.NIL;
                    }
                    lispObject = Lisp51ToolKit.Cdr(lispObject);
                }
                return lispObject2;
            }
        }, true);
        this.AddPrimitive("OR", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "OR", 0, -1);
                LispObject lispObject2 = Lisp51ToolKit.T;
                while (Lisp51ToolKit.Consp(lispObject)) {
                    lispObject2 = Primitive.this.evaluater.EvalSexpr(Lisp51ToolKit.Car(lispObject));
                    if (lispObject2 != Lisp51ToolKit.NIL) {
                        return lispObject2;
                    }
                    lispObject = Lisp51ToolKit.Cdr(lispObject);
                }
                return Lisp51ToolKit.NIL;
            }
        }, true);
        this.AddPrimitive("ABS", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "ABS", 1, 1);
                if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("ABS: argument must be a number:", Lisp51ToolKit.Car(lispObject));
                }
                return Lisp51ToolKit.MakeFixnum(Math.abs(Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject)).GetValue()));
            }
        });
        this.AddPrimitive("-", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "-", 1, -1);
                if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("-: all arguments must be numeric:", Lisp51ToolKit.Car(lispObject));
                }
                long l = Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject)).GetValue();
                if (!Lisp51ToolKit.Consp(lispObject = Lisp51ToolKit.Cdr(lispObject))) {
                    return Lisp51ToolKit.MakeFixnum(-l);
                }
                do {
                    if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject))) {
                        throw new LispException("-: all arguments must be numeric:", Lisp51ToolKit.Car(lispObject));
                    }
                    l -= Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject)).GetValue();
                } while (Lisp51ToolKit.Consp(lispObject = Lisp51ToolKit.Cdr(lispObject)));
                return Lisp51ToolKit.MakeFixnum(l);
            }
        });
        this.AddPrimitive("+", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "+", 0, -1);
                long l = 0L;
                while (Lisp51ToolKit.Consp(lispObject)) {
                    if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject))) {
                        throw new LispException("+: all aguments must be numeric: " + Lisp51ToolKit.Car(lispObject));
                    }
                    l += Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject)).GetValue();
                    lispObject = Lisp51ToolKit.Cdr(lispObject);
                }
                return Lisp51ToolKit.MakeFixnum(l);
            }
        });
        this.AddPrimitive("*", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "*", 0, -1);
                long l = 1L;
                while (Lisp51ToolKit.Consp(lispObject)) {
                    if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject))) {
                        throw new LispException("*: all arguments must be numeric: " + Lisp51ToolKit.Car(lispObject));
                    }
                    l *= Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject)).GetValue();
                    lispObject = Lisp51ToolKit.Cdr(lispObject);
                }
                return Lisp51ToolKit.MakeFixnum(l);
            }
        });
        this.AddPrimitive("TRUNCATE", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                if (Primitive.this.CheckArgs(lispObject, "TRUNCATE", 1, 2) == 1) {
                    if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject))) {
                        throw new LispException("TRUNCATE: argument is not a number: " + Lisp51ToolKit.Car(lispObject));
                    }
                    return Lisp51ToolKit.Car(lispObject);
                }
                if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("TRUNCATE: first argument is not a number: " + Lisp51ToolKit.Car(lispObject));
                }
                if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Cadr(lispObject))) {
                    throw new LispException("TRUNCATE: second argument is not a number: " + Lisp51ToolKit.Cadr(lispObject));
                }
                long l = Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject)).GetValue();
                long l2 = Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Cadr(lispObject)).GetValue();
                if (l2 == 0L) {
                    throw new LispException("TRUNCATE: division by zero: " + Lisp51ToolKit.Cadr(lispObject));
                }
                return Lisp51ToolKit.MakeFixnum(l / l2 - (long)(l < 0L && l % l2 != 0L ? (l2 < 0L ? -1 : 1) : 0));
            }
        });
        this.AddPrimitive("REM", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                if (Primitive.this.CheckArgs(lispObject, "REM", 1, 2) == 1) {
                    if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject))) {
                        throw new LispException("REM: argument is not a number: " + Lisp51ToolKit.Car(lispObject));
                    }
                    return Lisp51ToolKit.Car(lispObject);
                }
                if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("REM: first argument is not a number: " + Lisp51ToolKit.Car(lispObject));
                }
                if (!Lisp51ToolKit.Fixnump(Lisp51ToolKit.Cadr(lispObject))) {
                    throw new LispException("REM: second argument is not a number: " + Lisp51ToolKit.Cadr(lispObject));
                }
                long l = Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Car(lispObject)).GetValue();
                long l2 = Lisp51ToolKit.CvtToFixnum(Lisp51ToolKit.Cadr(lispObject)).GetValue();
                if (l2 == 0L) {
                    throw new LispException("REM: division by zero: " + Lisp51ToolKit.Cadr(lispObject));
                }
                return Lisp51ToolKit.MakeFixnum(l % l2);
            }
        });
        this.AddPrimitive("MAKE-ARRAY", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "MAKE-ARRAY", 1, 1);
                if (!Lisp51ToolKit.Consp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("MAKE-ARRAY: first argument must be a list of positive integers: ", Lisp51ToolKit.Car(lispObject));
                }
                int[] nArray = Primitive.ConsToRefList(Lisp51ToolKit.Car(lispObject));
                return Lisp51ToolKit.MakeArray(nArray);
            }
        });
        this.AddPrimitive("AREF", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "AREF", 2, -1);
                if (!Lisp51ToolKit.LispArrayp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("AREF: first argument must be an array: ", Lisp51ToolKit.Car(lispObject));
                }
                LispArray lispArray = Lisp51ToolKit.CvtToLispArray(Lisp51ToolKit.Car(lispObject));
                int[] nArray = Primitive.ConsToRefList(Lisp51ToolKit.Cdr(lispObject));
                if (lispArray.GetRank() != nArray.length) {
                    throw new LispException("AREF: incorrect # of dimensions for array reference: ", Lisp51ToolKit.Cdr(lispObject));
                }
                return lispArray.GetElementAt(nArray);
            }
        });
        this.AddPrimitive("AREF-SET", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "AREF-SET", 3, -1);
                if (!Lisp51ToolKit.LispArrayp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("AREF-SET: first argument must be an array: ", Lisp51ToolKit.Car(lispObject));
                }
                LispArray lispArray = Lisp51ToolKit.CvtToLispArray(Lisp51ToolKit.Car(lispObject));
                LispObject lispObject2 = Lisp51ToolKit.Cadr(lispObject);
                int[] nArray = Primitive.ConsToRefList(Lisp51ToolKit.Cddr(lispObject));
                if (lispArray.GetRank() != nArray.length) {
                    throw new LispException("AREF-SET: incorrect # of dimensions for array reference: ", Lisp51ToolKit.Cadr(lispObject));
                }
                lispArray.SetElementAt(nArray, lispObject2);
                return lispObject2;
            }
        });
        this.AddPrimitive("ARRAY-DIMENSIONS", new Callable(){

            public LispObject Call(LispObject lispObject) throws LispException {
                Primitive.this.CheckArgs(lispObject, "ARRAY-DIMENSIONS", 1, 1);
                if (!Lisp51ToolKit.LispArrayp(Lisp51ToolKit.Car(lispObject))) {
                    throw new LispException("ARRAY-DIMENSIONS: argument must be an array: ", Lisp51ToolKit.Car(lispObject));
                }
                LispObject lispObject2 = Primitive.this.RefListToCons(Lisp51ToolKit.CvtToLispArray(Lisp51ToolKit.Car(lispObject)).GetDimensions());
                return lispObject2;
            }
        });
    }

    public static int Length(LispObject lispObject) throws LispException {
        int n = 0;
        if (!Primitive.Consp(lispObject) && lispObject != NIL) {
            return -1;
        }
        while (Primitive.Consp(lispObject)) {
            ++n;
            lispObject = Primitive.Cdr(lispObject);
        }
        return n;
    }

    public static LispObject Nth(long l, LispObject lispObject) throws LispException {
        int n = 0;
        while ((long)n < l) {
            lispObject = Primitive.Cdr(lispObject);
            ++n;
        }
        return Primitive.Car(lispObject);
    }

    public static LispObject NthCdr(long l, LispObject lispObject) throws LispException {
        int n = 0;
        while ((long)n < l) {
            lispObject = Primitive.Cdr(lispObject);
            ++n;
        }
        return lispObject;
    }

    public static LispObject CopyList(LispObject lispObject) throws LispException {
        LispObject lispObject2;
        if (!Primitive.Consp(lispObject)) {
            return lispObject;
        }
        Cons cons = lispObject2 = Primitive.MakeCons(Primitive.Car(lispObject), NIL);
        Primitive.Preserve(cons);
        while (Primitive.Consp(Primitive.Cdr(lispObject))) {
            Primitive.CvtToCons(lispObject2).SetCdr(Primitive.MakeCons(Primitive.Cadr(lispObject), NIL));
            lispObject = Primitive.Cdr(lispObject);
            lispObject2 = Primitive.Cdr(lispObject2);
        }
        Primitive.CvtToCons(lispObject2).SetCdr(Primitive.Cdr(lispObject));
        Primitive.Release();
        return cons;
    }

    public static LispObject Reverse(LispObject lispObject) throws LispException {
        LispObject lispObject2;
        if (!Primitive.Consp(lispObject)) {
            return lispObject;
        }
        Primitive.Preserve(lispObject);
        LispObject lispObject3 = lispObject2 = NIL;
        lispObject3 = Primitive.MakeCons(Primitive.Car(lispObject), NIL);
        lispObject = Primitive.Cdr(lispObject);
        Primitive.Preserve(lispObject3);
        while (Primitive.Consp(lispObject)) {
            lispObject2 = Primitive.Car(lispObject);
            lispObject = Primitive.Cdr(lispObject);
            lispObject3 = Primitive.MakeCons(lispObject2, lispObject3);
            Primitive.Release();
            Primitive.Preserve(lispObject3);
        }
        Primitive.Release();
        LispObject lispObject4 = Primitive.Release();
        if (lispObject != NIL) {
            throw new LispException("REVERSE: argument is a dotted list", lispObject4);
        }
        return lispObject3;
    }

    public static boolean Equal(LispObject lispObject, LispObject lispObject2) throws LispException {
        if (lispObject == lispObject2) {
            return true;
        }
        if (Primitive.Fixnump(lispObject) && Primitive.Fixnump(lispObject2) && Primitive.CvtToFixnum(lispObject).GetValue() == Primitive.CvtToFixnum(lispObject2).GetValue()) {
            return true;
        }
        return lispObject.toString().equals(lispObject2.toString());
    }

    public static LispObject Last(LispObject lispObject) throws LispException {
        if (!Primitive.Consp(lispObject)) {
            return lispObject;
        }
        while (Primitive.Consp(Primitive.Cdr(lispObject))) {
            lispObject = Primitive.Cdr(lispObject);
        }
        return lispObject;
    }

    public static int[] ConsToRefList(LispObject lispObject) throws LispException {
        int n = Primitive.Length(lispObject);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            LispObject lispObject2 = Primitive.Nth(i, lispObject);
            if (!Primitive.Fixnump(lispObject2) && Primitive.CvtToFixnum(lispObject2).GetValue() <= 0L) {
                throw new LispException("AREF: Array reference must be a list of positive integers", lispObject);
            }
            nArray[i] = (int)Primitive.CvtToFixnum(lispObject2).GetValue();
        }
        return nArray;
    }

    public LispObject RefListToCons(int[] nArray) throws LispException {
        LispObject lispObject = NIL;
        Primitive.Preserve(lispObject);
        for (int i = nArray.length - 1; i > -1; --i) {
            lispObject = Primitive.MakeCons(Primitive.MakeFixnum(nArray[i]), lispObject);
            Primitive.Release();
            Primitive.Preserve(lispObject);
        }
        Primitive.Release();
        return lispObject;
    }
}

